package me.snowdrop.istio.api.security.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class JWTHeaderFluentImpl<A extends JWTHeaderFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements JWTHeaderFluent<A>{

    private String name;
    private String prefix;

    public JWTHeaderFluentImpl(){
    }
    public JWTHeaderFluentImpl(JWTHeader instance){
            this.withName(instance.getName()); 
            this.withPrefix(instance.getPrefix()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getPrefix(){
            return this.prefix;
    }

    public A withPrefix(String prefix){
            this.prefix=prefix; return (A) this;
    }

    public Boolean hasPrefix(){
            return this.prefix != null;
    }

    public A withNewPrefix(String arg1){
            return (A)withPrefix(new String(arg1));
    }

    public A withNewPrefix(StringBuilder arg1){
            return (A)withPrefix(new String(arg1));
    }

    public A withNewPrefix(StringBuffer arg1){
            return (A)withPrefix(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            JWTHeaderFluentImpl that = (JWTHeaderFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (prefix != null ? !prefix.equals(that.prefix) :that.prefix != null) return false;
            return true;
    }




}
