
package me.snowdrop.istio.api.security.v1beta1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "audiences",
    "forwardOriginalToken",
    "fromHeaders",
    "fromParams",
    "issuer",
    "jwks",
    "jwksUri",
    "outputPayloadToHeader"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class JWTRule implements Serializable
{

    /**
     * 
     */
    @JsonProperty("audiences")
    @JsonPropertyDescription("")
    private List<String> audiences = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("forwardOriginalToken")
    @JsonPropertyDescription("")
    private Boolean forwardOriginalToken;
    /**
     * 
     */
    @JsonProperty("fromHeaders")
    @JsonPropertyDescription("")
    private List<JWTHeader> fromHeaders = new ArrayList<JWTHeader>();
    /**
     * 
     */
    @JsonProperty("fromParams")
    @JsonPropertyDescription("")
    private List<String> fromParams = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("issuer")
    @JsonPropertyDescription("")
    private String issuer;
    /**
     * 
     */
    @JsonProperty("jwks")
    @JsonPropertyDescription("")
    private String jwks;
    /**
     * 
     */
    @JsonProperty("jwksUri")
    @JsonPropertyDescription("")
    private String jwksUri;
    /**
     * 
     */
    @JsonProperty("outputPayloadToHeader")
    @JsonPropertyDescription("")
    private String outputPayloadToHeader;
    private final static long serialVersionUID = -5483094673519813442L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public JWTRule() {
    }

    /**
     * 
     * @param fromHeaders
     * @param jwks
     * @param fromParams
     * @param audiences
     * @param jwksUri
     * @param outputPayloadToHeader
     * @param forwardOriginalToken
     * @param issuer
     */
    public JWTRule(List<String> audiences, Boolean forwardOriginalToken, List<JWTHeader> fromHeaders, List<String> fromParams, String issuer, String jwks, String jwksUri, String outputPayloadToHeader) {
        super();
        this.audiences = audiences;
        this.forwardOriginalToken = forwardOriginalToken;
        this.fromHeaders = fromHeaders;
        this.fromParams = fromParams;
        this.issuer = issuer;
        this.jwks = jwks;
        this.jwksUri = jwksUri;
        this.outputPayloadToHeader = outputPayloadToHeader;
    }

    /**
     * 
     */
    public List<String> getAudiences() {
        return audiences;
    }

    /**
     * 
     */
    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    /**
     * 
     */
    public Boolean getForwardOriginalToken() {
        return forwardOriginalToken;
    }

    /**
     * 
     */
    public void setForwardOriginalToken(Boolean forwardOriginalToken) {
        this.forwardOriginalToken = forwardOriginalToken;
    }

    /**
     * 
     */
    public List<JWTHeader> getFromHeaders() {
        return fromHeaders;
    }

    /**
     * 
     */
    public void setFromHeaders(List<JWTHeader> fromHeaders) {
        this.fromHeaders = fromHeaders;
    }

    /**
     * 
     */
    public List<String> getFromParams() {
        return fromParams;
    }

    /**
     * 
     */
    public void setFromParams(List<String> fromParams) {
        this.fromParams = fromParams;
    }

    /**
     * 
     */
    public String getIssuer() {
        return issuer;
    }

    /**
     * 
     */
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    /**
     * 
     */
    public String getJwks() {
        return jwks;
    }

    /**
     * 
     */
    public void setJwks(String jwks) {
        this.jwks = jwks;
    }

    /**
     * 
     */
    public String getJwksUri() {
        return jwksUri;
    }

    /**
     * 
     */
    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    /**
     * 
     */
    public String getOutputPayloadToHeader() {
        return outputPayloadToHeader;
    }

    /**
     * 
     */
    public void setOutputPayloadToHeader(String outputPayloadToHeader) {
        this.outputPayloadToHeader = outputPayloadToHeader;
    }

}
