package me.snowdrop.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JWTRuleBuilder extends JWTRuleFluentImpl<JWTRuleBuilder> implements VisitableBuilder<JWTRule,JWTRuleBuilder>{

    JWTRuleFluent<?> fluent;
    Boolean validationEnabled;

    public JWTRuleBuilder(){
            this(true);
    }
    public JWTRuleBuilder(Boolean validationEnabled){
            this(new JWTRule(), validationEnabled);
    }
    public JWTRuleBuilder(JWTRuleFluent<?> fluent){
            this(fluent, true);
    }
    public JWTRuleBuilder(JWTRuleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new JWTRule(), validationEnabled);
    }
    public JWTRuleBuilder(JWTRuleFluent<?> fluent,JWTRule instance){
            this(fluent, instance, true);
    }
    public JWTRuleBuilder(JWTRuleFluent<?> fluent,JWTRule instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAudiences(instance.getAudiences()); 
            fluent.withForwardOriginalToken(instance.getForwardOriginalToken()); 
            fluent.withFromHeaders(instance.getFromHeaders()); 
            fluent.withFromParams(instance.getFromParams()); 
            fluent.withIssuer(instance.getIssuer()); 
            fluent.withJwks(instance.getJwks()); 
            fluent.withJwksUri(instance.getJwksUri()); 
            fluent.withOutputPayloadToHeader(instance.getOutputPayloadToHeader()); 
            this.validationEnabled = validationEnabled; 
    }
    public JWTRuleBuilder(JWTRule instance){
            this(instance,true);
    }
    public JWTRuleBuilder(JWTRule instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAudiences(instance.getAudiences()); 
            this.withForwardOriginalToken(instance.getForwardOriginalToken()); 
            this.withFromHeaders(instance.getFromHeaders()); 
            this.withFromParams(instance.getFromParams()); 
            this.withIssuer(instance.getIssuer()); 
            this.withJwks(instance.getJwks()); 
            this.withJwksUri(instance.getJwksUri()); 
            this.withOutputPayloadToHeader(instance.getOutputPayloadToHeader()); 
            this.validationEnabled = validationEnabled; 
    }

    public JWTRule build(){
            JWTRule buildable = new JWTRule(fluent.getAudiences(),fluent.isForwardOriginalToken(),fluent.getFromHeaders(),fluent.getFromParams(),fluent.getIssuer(),fluent.getJwks(),fluent.getJwksUri(),fluent.getOutputPayloadToHeader());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JWTRuleBuilder that = (JWTRuleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
