package me.snowdrop.istio.api.security.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface JWTRuleFluent<A extends JWTRuleFluent<A>> extends Fluent<A>{


    public A addToAudiences(int index,String item);
    public A setToAudiences(int index,String item);
    public A addToAudiences(String... items);
    public A addAllToAudiences(Collection<String> items);
    public A removeFromAudiences(String... items);
    public A removeAllFromAudiences(Collection<String> items);
    public List<String> getAudiences();
    public String getAudience(int index);
    public String getFirstAudience();
    public String getLastAudience();
    public String getMatchingAudience(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingAudience(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withAudiences(List<String> audiences);
    public A withAudiences(String... audiences);
    public Boolean hasAudiences();
    public A addNewAudience(String arg1);
    public A addNewAudience(StringBuilder arg1);
    public A addNewAudience(StringBuffer arg1);
    public Boolean isForwardOriginalToken();
    public A withForwardOriginalToken(Boolean forwardOriginalToken);
    public Boolean hasForwardOriginalToken();
    public A withNewForwardOriginalToken(String arg1);
    public A withNewForwardOriginalToken(boolean arg1);
    public A addToFromHeaders(int index,JWTHeader item);
    public A setToFromHeaders(int index,JWTHeader item);
    public A addToFromHeaders(JWTHeader... items);
    public A addAllToFromHeaders(Collection<JWTHeader> items);
    public A removeFromFromHeaders(JWTHeader... items);
    public A removeAllFromFromHeaders(Collection<JWTHeader> items);
    public A removeMatchingFromFromHeaders(io.fabric8.kubernetes.api.builder.Predicate<JWTHeaderBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildFromHeaders instead.
 * @return The buildable object.
 */
@Deprecated public List<JWTHeader> getFromHeaders();
    public List<JWTHeader> buildFromHeaders();
    public JWTHeader buildFromHeader(int index);
    public JWTHeader buildFirstFromHeader();
    public JWTHeader buildLastFromHeader();
    public JWTHeader buildMatchingFromHeader(io.fabric8.kubernetes.api.builder.Predicate<JWTHeaderBuilder> predicate);
    public Boolean hasMatchingFromHeader(io.fabric8.kubernetes.api.builder.Predicate<JWTHeaderBuilder> predicate);
    public A withFromHeaders(List<JWTHeader> fromHeaders);
    public A withFromHeaders(JWTHeader... fromHeaders);
    public Boolean hasFromHeaders();
    public A addNewFromHeader(String name,String prefix);
    public JWTRuleFluent.FromHeadersNested<A> addNewFromHeader();
    public JWTRuleFluent.FromHeadersNested<A> addNewFromHeaderLike(JWTHeader item);
    public JWTRuleFluent.FromHeadersNested<A> setNewFromHeaderLike(int index,JWTHeader item);
    public JWTRuleFluent.FromHeadersNested<A> editFromHeader(int index);
    public JWTRuleFluent.FromHeadersNested<A> editFirstFromHeader();
    public JWTRuleFluent.FromHeadersNested<A> editLastFromHeader();
    public JWTRuleFluent.FromHeadersNested<A> editMatchingFromHeader(io.fabric8.kubernetes.api.builder.Predicate<JWTHeaderBuilder> predicate);
    public A addToFromParams(int index,String item);
    public A setToFromParams(int index,String item);
    public A addToFromParams(String... items);
    public A addAllToFromParams(Collection<String> items);
    public A removeFromFromParams(String... items);
    public A removeAllFromFromParams(Collection<String> items);
    public List<String> getFromParams();
    public String getFromParam(int index);
    public String getFirstFromParam();
    public String getLastFromParam();
    public String getMatchingFromParam(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingFromParam(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withFromParams(List<String> fromParams);
    public A withFromParams(String... fromParams);
    public Boolean hasFromParams();
    public A addNewFromParam(String arg1);
    public A addNewFromParam(StringBuilder arg1);
    public A addNewFromParam(StringBuffer arg1);
    public String getIssuer();
    public A withIssuer(String issuer);
    public Boolean hasIssuer();
    public A withNewIssuer(String arg1);
    public A withNewIssuer(StringBuilder arg1);
    public A withNewIssuer(StringBuffer arg1);
    public String getJwks();
    public A withJwks(String jwks);
    public Boolean hasJwks();
    public A withNewJwks(String arg1);
    public A withNewJwks(StringBuilder arg1);
    public A withNewJwks(StringBuffer arg1);
    public String getJwksUri();
    public A withJwksUri(String jwksUri);
    public Boolean hasJwksUri();
    public A withNewJwksUri(String arg1);
    public A withNewJwksUri(StringBuilder arg1);
    public A withNewJwksUri(StringBuffer arg1);
    public String getOutputPayloadToHeader();
    public A withOutputPayloadToHeader(String outputPayloadToHeader);
    public Boolean hasOutputPayloadToHeader();
    public A withNewOutputPayloadToHeader(String arg1);
    public A withNewOutputPayloadToHeader(StringBuilder arg1);
    public A withNewOutputPayloadToHeader(StringBuffer arg1);

    public interface FromHeadersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JWTHeaderFluent<JWTRuleFluent.FromHeadersNested<N>>{

        
    public N and();    public N endFromHeader();
}


}
