package me.snowdrop.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MutualTLSBuilder extends MutualTLSFluentImpl<MutualTLSBuilder> implements VisitableBuilder<MutualTLS,MutualTLSBuilder>{

    MutualTLSFluent<?> fluent;
    Boolean validationEnabled;

    public MutualTLSBuilder(){
            this(true);
    }
    public MutualTLSBuilder(Boolean validationEnabled){
            this(new MutualTLS(), validationEnabled);
    }
    public MutualTLSBuilder(MutualTLSFluent<?> fluent){
            this(fluent, true);
    }
    public MutualTLSBuilder(MutualTLSFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MutualTLS(), validationEnabled);
    }
    public MutualTLSBuilder(MutualTLSFluent<?> fluent,MutualTLS instance){
            this(fluent, instance, true);
    }
    public MutualTLSBuilder(MutualTLSFluent<?> fluent,MutualTLS instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMode(instance.getMode()); 
            this.validationEnabled = validationEnabled; 
    }
    public MutualTLSBuilder(MutualTLS instance){
            this(instance,true);
    }
    public MutualTLSBuilder(MutualTLS instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMode(instance.getMode()); 
            this.validationEnabled = validationEnabled; 
    }

    public MutualTLS build(){
            MutualTLS buildable = new MutualTLS(fluent.getMode());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MutualTLSBuilder that = (MutualTLSBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
