package me.snowdrop.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OperationBuilder extends OperationFluentImpl<OperationBuilder> implements VisitableBuilder<me.snowdrop.istio.api.security.v1beta1.Operation,OperationBuilder>{

    OperationFluent<?> fluent;
    Boolean validationEnabled;

    public OperationBuilder(){
            this(true);
    }
    public OperationBuilder(Boolean validationEnabled){
            this(new Operation(), validationEnabled);
    }
    public OperationBuilder(OperationFluent<?> fluent){
            this(fluent, true);
    }
    public OperationBuilder(OperationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Operation(), validationEnabled);
    }
    public OperationBuilder(OperationFluent<?> fluent,me.snowdrop.istio.api.security.v1beta1.Operation instance){
            this(fluent, instance, true);
    }
    public OperationBuilder(OperationFluent<?> fluent,me.snowdrop.istio.api.security.v1beta1.Operation instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHosts(instance.getHosts()); 
            fluent.withMethods(instance.getMethods()); 
            fluent.withNotHosts(instance.getNotHosts()); 
            fluent.withNotMethods(instance.getNotMethods()); 
            fluent.withNotPaths(instance.getNotPaths()); 
            fluent.withNotPorts(instance.getNotPorts()); 
            fluent.withPaths(instance.getPaths()); 
            fluent.withPorts(instance.getPorts()); 
            this.validationEnabled = validationEnabled; 
    }
    public OperationBuilder(me.snowdrop.istio.api.security.v1beta1.Operation instance){
            this(instance,true);
    }
    public OperationBuilder(me.snowdrop.istio.api.security.v1beta1.Operation instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHosts(instance.getHosts()); 
            this.withMethods(instance.getMethods()); 
            this.withNotHosts(instance.getNotHosts()); 
            this.withNotMethods(instance.getNotMethods()); 
            this.withNotPaths(instance.getNotPaths()); 
            this.withNotPorts(instance.getNotPorts()); 
            this.withPaths(instance.getPaths()); 
            this.withPorts(instance.getPorts()); 
            this.validationEnabled = validationEnabled; 
    }

    public me.snowdrop.istio.api.security.v1beta1.Operation build(){
            Operation buildable = new Operation(fluent.getHosts(),fluent.getMethods(),fluent.getNotHosts(),fluent.getNotMethods(),fluent.getNotPaths(),fluent.getNotPorts(),fluent.getPaths(),fluent.getPorts());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OperationBuilder that = (OperationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
