package me.snowdrop.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PeerAuthenticationListBuilder extends PeerAuthenticationListFluentImpl<PeerAuthenticationListBuilder> implements VisitableBuilder<PeerAuthenticationList,PeerAuthenticationListBuilder>{

    PeerAuthenticationListFluent<?> fluent;
    Boolean validationEnabled;

    public PeerAuthenticationListBuilder(){
            this(true);
    }
    public PeerAuthenticationListBuilder(Boolean validationEnabled){
            this(new PeerAuthenticationList(), validationEnabled);
    }
    public PeerAuthenticationListBuilder(PeerAuthenticationListFluent<?> fluent){
            this(fluent, true);
    }
    public PeerAuthenticationListBuilder(PeerAuthenticationListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PeerAuthenticationList(), validationEnabled);
    }
    public PeerAuthenticationListBuilder(PeerAuthenticationListFluent<?> fluent,PeerAuthenticationList instance){
            this(fluent, instance, true);
    }
    public PeerAuthenticationListBuilder(PeerAuthenticationListFluent<?> fluent,PeerAuthenticationList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public PeerAuthenticationListBuilder(PeerAuthenticationList instance){
            this(instance,true);
    }
    public PeerAuthenticationListBuilder(PeerAuthenticationList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public PeerAuthenticationList build(){
            PeerAuthenticationList buildable = new PeerAuthenticationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PeerAuthenticationListBuilder that = (PeerAuthenticationListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
