
package me.snowdrop.istio.api.security.v1beta1;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.Version;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;
import me.snowdrop.istio.api.type.v1beta1.WorkloadSelector;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "mtls",
    "portLevelMtls",
    "selector"
})
@IstioKind(name = "PeerAuthentication", plural = "peerauthentications")
@IstioApiVersion("security.istio.io/v1beta1")
@Version("v1beta1")
@Group("security.istio.io")
@Plural("peerauthentications")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class PeerAuthenticationSpec implements Serializable, IstioSpec
{

    /**
     * 
     */
    @JsonProperty("mtls")
    @JsonPropertyDescription("")
    private me.snowdrop.istio.api.security.v1beta1.MutualTLS mtls;
    /**
     * 
     */
    @JsonProperty("portLevelMtls")
    @JsonPropertyDescription("")
    private Map<String, me.snowdrop.istio.api.security.v1beta1.MutualTLS> portLevelMtls;
    /**
     * 
     */
    @JsonProperty("selector")
    @JsonPropertyDescription("")
    private WorkloadSelector selector;
    private final static long serialVersionUID = 7725714963261300181L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public PeerAuthenticationSpec() {
    }

    /**
     * 
     * @param selector
     * @param mtls
     * @param portLevelMtls
     */
    public PeerAuthenticationSpec(me.snowdrop.istio.api.security.v1beta1.MutualTLS mtls, Map<String, me.snowdrop.istio.api.security.v1beta1.MutualTLS> portLevelMtls, WorkloadSelector selector) {
        super();
        this.mtls = mtls;
        this.portLevelMtls = portLevelMtls;
        this.selector = selector;
    }

    /**
     * 
     */
    public me.snowdrop.istio.api.security.v1beta1.MutualTLS getMtls() {
        return mtls;
    }

    /**
     * 
     */
    public void setMtls(me.snowdrop.istio.api.security.v1beta1.MutualTLS mtls) {
        this.mtls = mtls;
    }

    /**
     * 
     */
    public Map<String, me.snowdrop.istio.api.security.v1beta1.MutualTLS> getPortLevelMtls() {
        return portLevelMtls;
    }

    /**
     * 
     */
    public void setPortLevelMtls(Map<String, me.snowdrop.istio.api.security.v1beta1.MutualTLS> portLevelMtls) {
        this.portLevelMtls = portLevelMtls;
    }

    /**
     * 
     */
    public WorkloadSelector getSelector() {
        return selector;
    }

    /**
     * 
     */
    public void setSelector(WorkloadSelector selector) {
        this.selector = selector;
    }

}
