package me.snowdrop.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PeerAuthenticationSpecBuilder extends PeerAuthenticationSpecFluentImpl<PeerAuthenticationSpecBuilder> implements VisitableBuilder<PeerAuthenticationSpec,PeerAuthenticationSpecBuilder>{

    PeerAuthenticationSpecFluent<?> fluent;
    Boolean validationEnabled;

    public PeerAuthenticationSpecBuilder(){
            this(true);
    }
    public PeerAuthenticationSpecBuilder(Boolean validationEnabled){
            this(new PeerAuthenticationSpec(), validationEnabled);
    }
    public PeerAuthenticationSpecBuilder(PeerAuthenticationSpecFluent<?> fluent){
            this(fluent, true);
    }
    public PeerAuthenticationSpecBuilder(PeerAuthenticationSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PeerAuthenticationSpec(), validationEnabled);
    }
    public PeerAuthenticationSpecBuilder(PeerAuthenticationSpecFluent<?> fluent,PeerAuthenticationSpec instance){
            this(fluent, instance, true);
    }
    public PeerAuthenticationSpecBuilder(PeerAuthenticationSpecFluent<?> fluent,PeerAuthenticationSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMtls(instance.getMtls()); 
            fluent.withPortLevelMtls(instance.getPortLevelMtls()); 
            fluent.withSelector(instance.getSelector()); 
            this.validationEnabled = validationEnabled; 
    }
    public PeerAuthenticationSpecBuilder(PeerAuthenticationSpec instance){
            this(instance,true);
    }
    public PeerAuthenticationSpecBuilder(PeerAuthenticationSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMtls(instance.getMtls()); 
            this.withPortLevelMtls(instance.getPortLevelMtls()); 
            this.withSelector(instance.getSelector()); 
            this.validationEnabled = validationEnabled; 
    }

    public PeerAuthenticationSpec build(){
            PeerAuthenticationSpec buildable = new PeerAuthenticationSpec(fluent.getMtls(),fluent.getPortLevelMtls(),fluent.getSelector());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PeerAuthenticationSpecBuilder that = (PeerAuthenticationSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
