package me.snowdrop.istio.api.security.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import me.snowdrop.istio.api.type.v1beta1.WorkloadSelector;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;
import me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder;

public class PeerAuthenticationSpecFluentImpl<A extends PeerAuthenticationSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PeerAuthenticationSpecFluent<A>{

    private MutualTLSBuilder mtls;
    private Map<String,MutualTLS> portLevelMtls;
    private me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder selector;

    public PeerAuthenticationSpecFluentImpl(){
    }
    public PeerAuthenticationSpecFluentImpl(PeerAuthenticationSpec instance){
            this.withMtls(instance.getMtls()); 
            this.withPortLevelMtls(instance.getPortLevelMtls()); 
            this.withSelector(instance.getSelector()); 
    }

    
/**
 * This method has been deprecated, please use method buildMtls instead.
 * @return The buildable object.
 */
@Deprecated public MutualTLS getMtls(){
            return this.mtls!=null?this.mtls.build():null;
    }

    public MutualTLS buildMtls(){
            return this.mtls!=null?this.mtls.build():null;
    }

    public A withMtls(MutualTLS mtls){
            _visitables.get("mtls").remove(this.mtls);
            if (mtls!=null){ this.mtls= new MutualTLSBuilder(mtls); _visitables.get("mtls").add(this.mtls);} return (A) this;
    }

    public Boolean hasMtls(){
            return this.mtls != null;
    }

    public PeerAuthenticationSpecFluent.MtlsNested<A> withNewMtls(){
            return new MtlsNestedImpl();
    }

    public PeerAuthenticationSpecFluent.MtlsNested<A> withNewMtlsLike(MutualTLS item){
            return new MtlsNestedImpl(item);
    }

    public PeerAuthenticationSpecFluent.MtlsNested<A> editMtls(){
            return withNewMtlsLike(getMtls());
    }

    public PeerAuthenticationSpecFluent.MtlsNested<A> editOrNewMtls(){
            return withNewMtlsLike(getMtls() != null ? getMtls(): new MutualTLSBuilder().build());
    }

    public PeerAuthenticationSpecFluent.MtlsNested<A> editOrNewMtlsLike(MutualTLS item){
            return withNewMtlsLike(getMtls() != null ? getMtls(): item);
    }

    public A addToPortLevelMtls(String key,MutualTLS value){
            if(this.portLevelMtls == null && key != null && value != null) { this.portLevelMtls = new LinkedHashMap<String,MutualTLS>(); }
            if(key != null && value != null) {this.portLevelMtls.put(key, value);} return (A)this;
    }

    public A addToPortLevelMtls(Map<String,MutualTLS> map){
            if(this.portLevelMtls == null && map != null) { this.portLevelMtls = new LinkedHashMap<String,MutualTLS>(); }
            if(map != null) { this.portLevelMtls.putAll(map);} return (A)this;
    }

    public A removeFromPortLevelMtls(String key){
            if(this.portLevelMtls == null) { return (A) this; }
            if(key != null && this.portLevelMtls != null) {this.portLevelMtls.remove(key);} return (A)this;
    }

    public A removeFromPortLevelMtls(Map<String,MutualTLS> map){
            if(this.portLevelMtls == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.portLevelMtls != null){this.portLevelMtls.remove(key);}}} return (A)this;
    }

    public Map<String,MutualTLS> getPortLevelMtls(){
            return this.portLevelMtls;
    }

    public A withPortLevelMtls(Map<String,MutualTLS> portLevelMtls){
            if (portLevelMtls == null) { this.portLevelMtls =  null;} else {this.portLevelMtls = new LinkedHashMap<String,MutualTLS>(portLevelMtls);} return (A) this;
    }

    public Boolean hasPortLevelMtls(){
            return this.portLevelMtls != null;
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.type.v1beta1.WorkloadSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public me.snowdrop.istio.api.type.v1beta1.WorkloadSelector buildSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(me.snowdrop.istio.api.type.v1beta1.WorkloadSelector selector){
            _visitables.get("selector").remove(this.selector);
            if (selector!=null){ this.selector= new me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector(){
            return this.selector != null;
    }

    public PeerAuthenticationSpecFluent.V1beta1SelectorNested<A> withNewV1beta1Selector(){
            return new V1beta1SelectorNestedImpl();
    }

    public PeerAuthenticationSpecFluent.V1beta1SelectorNested<A> withNewSelectorLike(me.snowdrop.istio.api.type.v1beta1.WorkloadSelector item){
            return new V1beta1SelectorNestedImpl(item);
    }

    public PeerAuthenticationSpecFluent.V1beta1SelectorNested<A> editV1beta1Selector(){
            return withNewSelectorLike(getSelector());
    }

    public PeerAuthenticationSpecFluent.V1beta1SelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder().build());
    }

    public PeerAuthenticationSpecFluent.V1beta1SelectorNested<A> editOrNewSelectorLike(me.snowdrop.istio.api.type.v1beta1.WorkloadSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            PeerAuthenticationSpecFluentImpl that = (PeerAuthenticationSpecFluentImpl) o;
            if (mtls != null ? !mtls.equals(that.mtls) :that.mtls != null) return false;
            if (portLevelMtls != null ? !portLevelMtls.equals(that.portLevelMtls) :that.portLevelMtls != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            return true;
    }


    public class MtlsNestedImpl<N> extends MutualTLSFluentImpl<PeerAuthenticationSpecFluent.MtlsNested<N>> implements PeerAuthenticationSpecFluent.MtlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final MutualTLSBuilder builder;
    
            MtlsNestedImpl(MutualTLS item){
                    this.builder = new MutualTLSBuilder(this, item);
            }
            MtlsNestedImpl(){
                    this.builder = new MutualTLSBuilder(this);
            }
    
    public N and(){
            return (N) PeerAuthenticationSpecFluentImpl.this.withMtls(builder.build());
    }
    public N endMtls(){
            return and();
    }

}
    public class V1beta1SelectorNestedImpl<N> extends me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorFluentImpl<PeerAuthenticationSpecFluent.V1beta1SelectorNested<N>> implements PeerAuthenticationSpecFluent.V1beta1SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder builder;
    
            V1beta1SelectorNestedImpl(me.snowdrop.istio.api.type.v1beta1.WorkloadSelector item){
                    this.builder = new me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder(this, item);
            }
            V1beta1SelectorNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder(this);
            }
    
    public N and(){
            return (N) PeerAuthenticationSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endV1beta1Selector(){
            return and();
    }

}


}
