package me.snowdrop.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RequestAuthenticationBuilder extends RequestAuthenticationFluentImpl<RequestAuthenticationBuilder> implements VisitableBuilder<RequestAuthentication,RequestAuthenticationBuilder>{

    RequestAuthenticationFluent<?> fluent;
    Boolean validationEnabled;

    public RequestAuthenticationBuilder(){
            this(true);
    }
    public RequestAuthenticationBuilder(Boolean validationEnabled){
            this(new RequestAuthentication(), validationEnabled);
    }
    public RequestAuthenticationBuilder(RequestAuthenticationFluent<?> fluent){
            this(fluent, true);
    }
    public RequestAuthenticationBuilder(RequestAuthenticationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RequestAuthentication(), validationEnabled);
    }
    public RequestAuthenticationBuilder(RequestAuthenticationFluent<?> fluent,RequestAuthentication instance){
            this(fluent, instance, true);
    }
    public RequestAuthenticationBuilder(RequestAuthenticationFluent<?> fluent,RequestAuthentication instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public RequestAuthenticationBuilder(RequestAuthentication instance){
            this(instance,true);
    }
    public RequestAuthenticationBuilder(RequestAuthentication instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public RequestAuthentication build(){
            RequestAuthentication buildable = new RequestAuthentication(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RequestAuthenticationBuilder that = (RequestAuthenticationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
