package me.snowdrop.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RequestAuthenticationListBuilder extends RequestAuthenticationListFluentImpl<RequestAuthenticationListBuilder> implements VisitableBuilder<RequestAuthenticationList,RequestAuthenticationListBuilder>{

    RequestAuthenticationListFluent<?> fluent;
    Boolean validationEnabled;

    public RequestAuthenticationListBuilder(){
            this(true);
    }
    public RequestAuthenticationListBuilder(Boolean validationEnabled){
            this(new RequestAuthenticationList(), validationEnabled);
    }
    public RequestAuthenticationListBuilder(RequestAuthenticationListFluent<?> fluent){
            this(fluent, true);
    }
    public RequestAuthenticationListBuilder(RequestAuthenticationListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RequestAuthenticationList(), validationEnabled);
    }
    public RequestAuthenticationListBuilder(RequestAuthenticationListFluent<?> fluent,RequestAuthenticationList instance){
            this(fluent, instance, true);
    }
    public RequestAuthenticationListBuilder(RequestAuthenticationListFluent<?> fluent,RequestAuthenticationList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public RequestAuthenticationListBuilder(RequestAuthenticationList instance){
            this(instance,true);
    }
    public RequestAuthenticationListBuilder(RequestAuthenticationList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public RequestAuthenticationList build(){
            RequestAuthenticationList buildable = new RequestAuthenticationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RequestAuthenticationListBuilder that = (RequestAuthenticationListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
