
package me.snowdrop.istio.api.security.v1beta1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.Version;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;
import me.snowdrop.istio.api.type.v1beta1.WorkloadSelector;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "jwtRules",
    "selector"
})
@IstioKind(name = "RequestAuthentication", plural = "requestauthentications")
@IstioApiVersion("security.istio.io/v1beta1")
@Version("v1beta1")
@Group("security.istio.io")
@Plural("requestauthentications")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class RequestAuthenticationSpec implements Serializable, IstioSpec
{

    /**
     * 
     */
    @JsonProperty("jwtRules")
    @JsonPropertyDescription("")
    private List<JWTRule> jwtRules = new ArrayList<JWTRule>();
    /**
     * 
     */
    @JsonProperty("selector")
    @JsonPropertyDescription("")
    private WorkloadSelector selector;
    private final static long serialVersionUID = -8039958030950684986L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RequestAuthenticationSpec() {
    }

    /**
     * 
     * @param selector
     * @param jwtRules
     */
    public RequestAuthenticationSpec(List<JWTRule> jwtRules, WorkloadSelector selector) {
        super();
        this.jwtRules = jwtRules;
        this.selector = selector;
    }

    /**
     * 
     */
    public List<JWTRule> getJwtRules() {
        return jwtRules;
    }

    /**
     * 
     */
    public void setJwtRules(List<JWTRule> jwtRules) {
        this.jwtRules = jwtRules;
    }

    /**
     * 
     */
    public WorkloadSelector getSelector() {
        return selector;
    }

    /**
     * 
     */
    public void setSelector(WorkloadSelector selector) {
        this.selector = selector;
    }

}
