package me.snowdrop.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RequestAuthenticationSpecBuilder extends RequestAuthenticationSpecFluentImpl<RequestAuthenticationSpecBuilder> implements VisitableBuilder<RequestAuthenticationSpec,RequestAuthenticationSpecBuilder>{

    RequestAuthenticationSpecFluent<?> fluent;
    Boolean validationEnabled;

    public RequestAuthenticationSpecBuilder(){
            this(true);
    }
    public RequestAuthenticationSpecBuilder(Boolean validationEnabled){
            this(new RequestAuthenticationSpec(), validationEnabled);
    }
    public RequestAuthenticationSpecBuilder(RequestAuthenticationSpecFluent<?> fluent){
            this(fluent, true);
    }
    public RequestAuthenticationSpecBuilder(RequestAuthenticationSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RequestAuthenticationSpec(), validationEnabled);
    }
    public RequestAuthenticationSpecBuilder(RequestAuthenticationSpecFluent<?> fluent,RequestAuthenticationSpec instance){
            this(fluent, instance, true);
    }
    public RequestAuthenticationSpecBuilder(RequestAuthenticationSpecFluent<?> fluent,RequestAuthenticationSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withJwtRules(instance.getJwtRules()); 
            fluent.withSelector(instance.getSelector()); 
            this.validationEnabled = validationEnabled; 
    }
    public RequestAuthenticationSpecBuilder(RequestAuthenticationSpec instance){
            this(instance,true);
    }
    public RequestAuthenticationSpecBuilder(RequestAuthenticationSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withJwtRules(instance.getJwtRules()); 
            this.withSelector(instance.getSelector()); 
            this.validationEnabled = validationEnabled; 
    }

    public RequestAuthenticationSpec build(){
            RequestAuthenticationSpec buildable = new RequestAuthenticationSpec(fluent.getJwtRules(),fluent.getSelector());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RequestAuthenticationSpecBuilder that = (RequestAuthenticationSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
