package me.snowdrop.istio.api.security.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import me.snowdrop.istio.api.type.v1beta1.WorkloadSelector;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder;
import me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorFluentImpl;
import java.util.Collection;
import java.lang.Object;

public class RequestAuthenticationSpecFluentImpl<A extends RequestAuthenticationSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RequestAuthenticationSpecFluent<A>{

    private List<JWTRuleBuilder> jwtRules;
    private me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder selector;

    public RequestAuthenticationSpecFluentImpl(){
    }
    public RequestAuthenticationSpecFluentImpl(RequestAuthenticationSpec instance){
            this.withJwtRules(instance.getJwtRules()); 
            this.withSelector(instance.getSelector()); 
    }

    public A addToJwtRules(int index,JWTRule item){
            if (this.jwtRules == null) {this.jwtRules = new ArrayList<JWTRuleBuilder>();}
            JWTRuleBuilder builder = new JWTRuleBuilder(item);_visitables.get("jwtRules").add(index >= 0 ? index : _visitables.get("jwtRules").size(), builder);this.jwtRules.add(index >= 0 ? index : jwtRules.size(), builder); return (A)this;
    }

    public A setToJwtRules(int index,JWTRule item){
            if (this.jwtRules == null) {this.jwtRules = new ArrayList<JWTRuleBuilder>();}
            JWTRuleBuilder builder = new JWTRuleBuilder(item);
            if (index < 0 || index >= _visitables.get("jwtRules").size()) { _visitables.get("jwtRules").add(builder); } else { _visitables.get("jwtRules").set(index, builder);}
            if (index < 0 || index >= jwtRules.size()) { jwtRules.add(builder); } else { jwtRules.set(index, builder);}
             return (A)this;
    }

    public A addToJwtRules(JWTRule... items){
            if (this.jwtRules == null) {this.jwtRules = new ArrayList<JWTRuleBuilder>();}
            for (JWTRule item : items) {JWTRuleBuilder builder = new JWTRuleBuilder(item);_visitables.get("jwtRules").add(builder);this.jwtRules.add(builder);} return (A)this;
    }

    public A addAllToJwtRules(Collection<JWTRule> items){
            if (this.jwtRules == null) {this.jwtRules = new ArrayList<JWTRuleBuilder>();}
            for (JWTRule item : items) {JWTRuleBuilder builder = new JWTRuleBuilder(item);_visitables.get("jwtRules").add(builder);this.jwtRules.add(builder);} return (A)this;
    }

    public A removeFromJwtRules(JWTRule... items){
            for (JWTRule item : items) {JWTRuleBuilder builder = new JWTRuleBuilder(item);_visitables.get("jwtRules").remove(builder);if (this.jwtRules != null) {this.jwtRules.remove(builder);}} return (A)this;
    }

    public A removeAllFromJwtRules(Collection<JWTRule> items){
            for (JWTRule item : items) {JWTRuleBuilder builder = new JWTRuleBuilder(item);_visitables.get("jwtRules").remove(builder);if (this.jwtRules != null) {this.jwtRules.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromJwtRules(io.fabric8.kubernetes.api.builder.Predicate<JWTRuleBuilder> predicate){
            if (jwtRules == null) return (A) this;
            final Iterator<JWTRuleBuilder> each = jwtRules.iterator();
            final List visitables = _visitables.get("jwtRules");
            while (each.hasNext()) {
              JWTRuleBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildJwtRules instead.
 * @return The buildable object.
 */
@Deprecated public List<JWTRule> getJwtRules(){
            return build(jwtRules);
    }

    public List<JWTRule> buildJwtRules(){
            return build(jwtRules);
    }

    public JWTRule buildJwtRule(int index){
            return this.jwtRules.get(index).build();
    }

    public JWTRule buildFirstJwtRule(){
            return this.jwtRules.get(0).build();
    }

    public JWTRule buildLastJwtRule(){
            return this.jwtRules.get(jwtRules.size() - 1).build();
    }

    public JWTRule buildMatchingJwtRule(io.fabric8.kubernetes.api.builder.Predicate<JWTRuleBuilder> predicate){
            for (JWTRuleBuilder item: jwtRules) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingJwtRule(io.fabric8.kubernetes.api.builder.Predicate<JWTRuleBuilder> predicate){
            for (JWTRuleBuilder item: jwtRules) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withJwtRules(List<JWTRule> jwtRules){
            if (this.jwtRules != null) { _visitables.get("jwtRules").removeAll(this.jwtRules);}
            if (jwtRules != null) {this.jwtRules = new ArrayList<JWTRuleBuilder>(); for (JWTRule item : jwtRules){this.addToJwtRules(item);}} else { this.jwtRules = null;} return (A) this;
    }

    public A withJwtRules(JWTRule... jwtRules){
            if (this.jwtRules != null) {this.jwtRules.clear();}
            if (jwtRules != null) {for (JWTRule item :jwtRules){ this.addToJwtRules(item);}} return (A) this;
    }

    public Boolean hasJwtRules(){
            return jwtRules != null && !jwtRules.isEmpty();
    }

    public RequestAuthenticationSpecFluent.JwtRulesNested<A> addNewJwtRule(){
            return new JwtRulesNestedImpl();
    }

    public RequestAuthenticationSpecFluent.JwtRulesNested<A> addNewJwtRuleLike(JWTRule item){
            return new JwtRulesNestedImpl(-1, item);
    }

    public RequestAuthenticationSpecFluent.JwtRulesNested<A> setNewJwtRuleLike(int index,JWTRule item){
            return new JwtRulesNestedImpl(index, item);
    }

    public RequestAuthenticationSpecFluent.JwtRulesNested<A> editJwtRule(int index){
            if (jwtRules.size() <= index) throw new RuntimeException("Can't edit jwtRules. Index exceeds size.");
            return setNewJwtRuleLike(index, buildJwtRule(index));
    }

    public RequestAuthenticationSpecFluent.JwtRulesNested<A> editFirstJwtRule(){
            if (jwtRules.size() == 0) throw new RuntimeException("Can't edit first jwtRules. The list is empty.");
            return setNewJwtRuleLike(0, buildJwtRule(0));
    }

    public RequestAuthenticationSpecFluent.JwtRulesNested<A> editLastJwtRule(){
            int index = jwtRules.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last jwtRules. The list is empty.");
            return setNewJwtRuleLike(index, buildJwtRule(index));
    }

    public RequestAuthenticationSpecFluent.JwtRulesNested<A> editMatchingJwtRule(io.fabric8.kubernetes.api.builder.Predicate<JWTRuleBuilder> predicate){
            int index = -1;
            for (int i=0;i<jwtRules.size();i++) { 
            if (predicate.apply(jwtRules.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching jwtRules. No match found.");
            return setNewJwtRuleLike(index, buildJwtRule(index));
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.type.v1beta1.WorkloadSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public me.snowdrop.istio.api.type.v1beta1.WorkloadSelector buildSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(me.snowdrop.istio.api.type.v1beta1.WorkloadSelector selector){
            _visitables.get("selector").remove(this.selector);
            if (selector!=null){ this.selector= new me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector(){
            return this.selector != null;
    }

    public RequestAuthenticationSpecFluent.V1beta1SelectorNested<A> withNewV1beta1Selector(){
            return new V1beta1SelectorNestedImpl();
    }

    public RequestAuthenticationSpecFluent.V1beta1SelectorNested<A> withNewSelectorLike(me.snowdrop.istio.api.type.v1beta1.WorkloadSelector item){
            return new V1beta1SelectorNestedImpl(item);
    }

    public RequestAuthenticationSpecFluent.V1beta1SelectorNested<A> editV1beta1Selector(){
            return withNewSelectorLike(getSelector());
    }

    public RequestAuthenticationSpecFluent.V1beta1SelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder().build());
    }

    public RequestAuthenticationSpecFluent.V1beta1SelectorNested<A> editOrNewSelectorLike(me.snowdrop.istio.api.type.v1beta1.WorkloadSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            RequestAuthenticationSpecFluentImpl that = (RequestAuthenticationSpecFluentImpl) o;
            if (jwtRules != null ? !jwtRules.equals(that.jwtRules) :that.jwtRules != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            return true;
    }


    public class JwtRulesNestedImpl<N> extends JWTRuleFluentImpl<RequestAuthenticationSpecFluent.JwtRulesNested<N>> implements RequestAuthenticationSpecFluent.JwtRulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final JWTRuleBuilder builder;
        private final int index;
    
            JwtRulesNestedImpl(int index,JWTRule item){
                    this.index = index;
                    this.builder = new JWTRuleBuilder(this, item);
            }
            JwtRulesNestedImpl(){
                    this.index = -1;
                    this.builder = new JWTRuleBuilder(this);
            }
    
    public N and(){
            return (N) RequestAuthenticationSpecFluentImpl.this.setToJwtRules(index,builder.build());
    }
    public N endJwtRule(){
            return and();
    }

}
    public class V1beta1SelectorNestedImpl<N> extends me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorFluentImpl<RequestAuthenticationSpecFluent.V1beta1SelectorNested<N>> implements RequestAuthenticationSpecFluent.V1beta1SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder builder;
    
            V1beta1SelectorNestedImpl(me.snowdrop.istio.api.type.v1beta1.WorkloadSelector item){
                    this.builder = new me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder(this, item);
            }
            V1beta1SelectorNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder(this);
            }
    
    public N and(){
            return (N) RequestAuthenticationSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endV1beta1Selector(){
            return and();
    }

}


}
