package me.snowdrop.istio.api.security.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class RuleFluentImpl<A extends RuleFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RuleFluent<A>{

    private List<FromBuilder> from;
    private List<ToBuilder> to;
    private List<ConditionBuilder> when;

    public RuleFluentImpl(){
    }
    public RuleFluentImpl(Rule instance){
            this.withFrom(instance.getFrom()); 
            this.withTo(instance.getTo()); 
            this.withWhen(instance.getWhen()); 
    }

    public A addToFrom(int index,From item){
            if (this.from == null) {this.from = new ArrayList<FromBuilder>();}
            FromBuilder builder = new FromBuilder(item);_visitables.get("from").add(index >= 0 ? index : _visitables.get("from").size(), builder);this.from.add(index >= 0 ? index : from.size(), builder); return (A)this;
    }

    public A setToFrom(int index,From item){
            if (this.from == null) {this.from = new ArrayList<FromBuilder>();}
            FromBuilder builder = new FromBuilder(item);
            if (index < 0 || index >= _visitables.get("from").size()) { _visitables.get("from").add(builder); } else { _visitables.get("from").set(index, builder);}
            if (index < 0 || index >= from.size()) { from.add(builder); } else { from.set(index, builder);}
             return (A)this;
    }

    public A addToFrom(From... items){
            if (this.from == null) {this.from = new ArrayList<FromBuilder>();}
            for (From item : items) {FromBuilder builder = new FromBuilder(item);_visitables.get("from").add(builder);this.from.add(builder);} return (A)this;
    }

    public A addAllToFrom(Collection<From> items){
            if (this.from == null) {this.from = new ArrayList<FromBuilder>();}
            for (From item : items) {FromBuilder builder = new FromBuilder(item);_visitables.get("from").add(builder);this.from.add(builder);} return (A)this;
    }

    public A removeFromFrom(From... items){
            for (From item : items) {FromBuilder builder = new FromBuilder(item);_visitables.get("from").remove(builder);if (this.from != null) {this.from.remove(builder);}} return (A)this;
    }

    public A removeAllFromFrom(Collection<From> items){
            for (From item : items) {FromBuilder builder = new FromBuilder(item);_visitables.get("from").remove(builder);if (this.from != null) {this.from.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromFrom(io.fabric8.kubernetes.api.builder.Predicate<FromBuilder> predicate){
            if (from == null) return (A) this;
            final Iterator<FromBuilder> each = from.iterator();
            final List visitables = _visitables.get("from");
            while (each.hasNext()) {
              FromBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildFrom instead.
 * @return The buildable object.
 */
@Deprecated public List<From> getFrom(){
            return build(from);
    }

    public List<From> buildFrom(){
            return build(from);
    }

    public From buildFrom(int index){
            return this.from.get(index).build();
    }

    public From buildFirstFrom(){
            return this.from.get(0).build();
    }

    public From buildLastFrom(){
            return this.from.get(from.size() - 1).build();
    }

    public From buildMatchingFrom(io.fabric8.kubernetes.api.builder.Predicate<FromBuilder> predicate){
            for (FromBuilder item: from) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingFrom(io.fabric8.kubernetes.api.builder.Predicate<FromBuilder> predicate){
            for (FromBuilder item: from) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withFrom(List<From> from){
            if (this.from != null) { _visitables.get("from").removeAll(this.from);}
            if (from != null) {this.from = new ArrayList<FromBuilder>(); for (From item : from){this.addToFrom(item);}} else { this.from = null;} return (A) this;
    }

    public A withFrom(From... from){
            if (this.from != null) {this.from.clear();}
            if (from != null) {for (From item :from){ this.addToFrom(item);}} return (A) this;
    }

    public Boolean hasFrom(){
            return from != null && !from.isEmpty();
    }

    public RuleFluent.FromNested<A> addNewFrom(){
            return new FromNestedImpl();
    }

    public RuleFluent.FromNested<A> addNewFromLike(From item){
            return new FromNestedImpl(-1, item);
    }

    public RuleFluent.FromNested<A> setNewFromLike(int index,From item){
            return new FromNestedImpl(index, item);
    }

    public RuleFluent.FromNested<A> editFrom(int index){
            if (from.size() <= index) throw new RuntimeException("Can't edit from. Index exceeds size.");
            return setNewFromLike(index, buildFrom(index));
    }

    public RuleFluent.FromNested<A> editFirstFrom(){
            if (from.size() == 0) throw new RuntimeException("Can't edit first from. The list is empty.");
            return setNewFromLike(0, buildFrom(0));
    }

    public RuleFluent.FromNested<A> editLastFrom(){
            int index = from.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last from. The list is empty.");
            return setNewFromLike(index, buildFrom(index));
    }

    public RuleFluent.FromNested<A> editMatchingFrom(io.fabric8.kubernetes.api.builder.Predicate<FromBuilder> predicate){
            int index = -1;
            for (int i=0;i<from.size();i++) { 
            if (predicate.apply(from.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching from. No match found.");
            return setNewFromLike(index, buildFrom(index));
    }

    public A addToTo(int index,To item){
            if (this.to == null) {this.to = new ArrayList<ToBuilder>();}
            ToBuilder builder = new ToBuilder(item);_visitables.get("to").add(index >= 0 ? index : _visitables.get("to").size(), builder);this.to.add(index >= 0 ? index : to.size(), builder); return (A)this;
    }

    public A setToTo(int index,To item){
            if (this.to == null) {this.to = new ArrayList<ToBuilder>();}
            ToBuilder builder = new ToBuilder(item);
            if (index < 0 || index >= _visitables.get("to").size()) { _visitables.get("to").add(builder); } else { _visitables.get("to").set(index, builder);}
            if (index < 0 || index >= to.size()) { to.add(builder); } else { to.set(index, builder);}
             return (A)this;
    }

    public A addToTo(To... items){
            if (this.to == null) {this.to = new ArrayList<ToBuilder>();}
            for (To item : items) {ToBuilder builder = new ToBuilder(item);_visitables.get("to").add(builder);this.to.add(builder);} return (A)this;
    }

    public A addAllToTo(Collection<To> items){
            if (this.to == null) {this.to = new ArrayList<ToBuilder>();}
            for (To item : items) {ToBuilder builder = new ToBuilder(item);_visitables.get("to").add(builder);this.to.add(builder);} return (A)this;
    }

    public A removeFromTo(To... items){
            for (To item : items) {ToBuilder builder = new ToBuilder(item);_visitables.get("to").remove(builder);if (this.to != null) {this.to.remove(builder);}} return (A)this;
    }

    public A removeAllFromTo(Collection<To> items){
            for (To item : items) {ToBuilder builder = new ToBuilder(item);_visitables.get("to").remove(builder);if (this.to != null) {this.to.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTo(io.fabric8.kubernetes.api.builder.Predicate<ToBuilder> predicate){
            if (to == null) return (A) this;
            final Iterator<ToBuilder> each = to.iterator();
            final List visitables = _visitables.get("to");
            while (each.hasNext()) {
              ToBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTo instead.
 * @return The buildable object.
 */
@Deprecated public List<To> getTo(){
            return build(to);
    }

    public List<To> buildTo(){
            return build(to);
    }

    public To buildTo(int index){
            return this.to.get(index).build();
    }

    public To buildFirstTo(){
            return this.to.get(0).build();
    }

    public To buildLastTo(){
            return this.to.get(to.size() - 1).build();
    }

    public To buildMatchingTo(io.fabric8.kubernetes.api.builder.Predicate<ToBuilder> predicate){
            for (ToBuilder item: to) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTo(io.fabric8.kubernetes.api.builder.Predicate<ToBuilder> predicate){
            for (ToBuilder item: to) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTo(List<To> to){
            if (this.to != null) { _visitables.get("to").removeAll(this.to);}
            if (to != null) {this.to = new ArrayList<ToBuilder>(); for (To item : to){this.addToTo(item);}} else { this.to = null;} return (A) this;
    }

    public A withTo(To... to){
            if (this.to != null) {this.to.clear();}
            if (to != null) {for (To item :to){ this.addToTo(item);}} return (A) this;
    }

    public Boolean hasTo(){
            return to != null && !to.isEmpty();
    }

    public RuleFluent.ToNested<A> addNewTo(){
            return new ToNestedImpl();
    }

    public RuleFluent.ToNested<A> addNewToLike(To item){
            return new ToNestedImpl(-1, item);
    }

    public RuleFluent.ToNested<A> setNewToLike(int index,To item){
            return new ToNestedImpl(index, item);
    }

    public RuleFluent.ToNested<A> editTo(int index){
            if (to.size() <= index) throw new RuntimeException("Can't edit to. Index exceeds size.");
            return setNewToLike(index, buildTo(index));
    }

    public RuleFluent.ToNested<A> editFirstTo(){
            if (to.size() == 0) throw new RuntimeException("Can't edit first to. The list is empty.");
            return setNewToLike(0, buildTo(0));
    }

    public RuleFluent.ToNested<A> editLastTo(){
            int index = to.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last to. The list is empty.");
            return setNewToLike(index, buildTo(index));
    }

    public RuleFluent.ToNested<A> editMatchingTo(io.fabric8.kubernetes.api.builder.Predicate<ToBuilder> predicate){
            int index = -1;
            for (int i=0;i<to.size();i++) { 
            if (predicate.apply(to.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching to. No match found.");
            return setNewToLike(index, buildTo(index));
    }

    public A addToWhen(int index,me.snowdrop.istio.api.security.v1beta1.Condition item){
            if (this.when == null) {this.when = new ArrayList<ConditionBuilder>();}
            me.snowdrop.istio.api.security.v1beta1.ConditionBuilder builder = new me.snowdrop.istio.api.security.v1beta1.ConditionBuilder(item);_visitables.get("when").add(index >= 0 ? index : _visitables.get("when").size(), builder);this.when.add(index >= 0 ? index : when.size(), builder); return (A)this;
    }

    public A setToWhen(int index,me.snowdrop.istio.api.security.v1beta1.Condition item){
            if (this.when == null) {this.when = new ArrayList<ConditionBuilder>();}
            me.snowdrop.istio.api.security.v1beta1.ConditionBuilder builder = new me.snowdrop.istio.api.security.v1beta1.ConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("when").size()) { _visitables.get("when").add(builder); } else { _visitables.get("when").set(index, builder);}
            if (index < 0 || index >= when.size()) { when.add(builder); } else { when.set(index, builder);}
             return (A)this;
    }

    public A addToWhen(me.snowdrop.istio.api.security.v1beta1.Condition... items){
            if (this.when == null) {this.when = new ArrayList<ConditionBuilder>();}
            for (me.snowdrop.istio.api.security.v1beta1.Condition item : items) {me.snowdrop.istio.api.security.v1beta1.ConditionBuilder builder = new me.snowdrop.istio.api.security.v1beta1.ConditionBuilder(item);_visitables.get("when").add(builder);this.when.add(builder);} return (A)this;
    }

    public A addAllToWhen(Collection<me.snowdrop.istio.api.security.v1beta1.Condition> items){
            if (this.when == null) {this.when = new ArrayList<ConditionBuilder>();}
            for (me.snowdrop.istio.api.security.v1beta1.Condition item : items) {me.snowdrop.istio.api.security.v1beta1.ConditionBuilder builder = new me.snowdrop.istio.api.security.v1beta1.ConditionBuilder(item);_visitables.get("when").add(builder);this.when.add(builder);} return (A)this;
    }

    public A removeFromWhen(me.snowdrop.istio.api.security.v1beta1.Condition... items){
            for (me.snowdrop.istio.api.security.v1beta1.Condition item : items) {me.snowdrop.istio.api.security.v1beta1.ConditionBuilder builder = new me.snowdrop.istio.api.security.v1beta1.ConditionBuilder(item);_visitables.get("when").remove(builder);if (this.when != null) {this.when.remove(builder);}} return (A)this;
    }

    public A removeAllFromWhen(Collection<me.snowdrop.istio.api.security.v1beta1.Condition> items){
            for (me.snowdrop.istio.api.security.v1beta1.Condition item : items) {me.snowdrop.istio.api.security.v1beta1.ConditionBuilder builder = new me.snowdrop.istio.api.security.v1beta1.ConditionBuilder(item);_visitables.get("when").remove(builder);if (this.when != null) {this.when.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromWhen(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            if (when == null) return (A) this;
            final Iterator<ConditionBuilder> each = when.iterator();
            final List visitables = _visitables.get("when");
            while (each.hasNext()) {
              ConditionBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildWhen instead.
 * @return The buildable object.
 */
@Deprecated public List<me.snowdrop.istio.api.security.v1beta1.Condition> getWhen(){
            return build(when);
    }

    public List<me.snowdrop.istio.api.security.v1beta1.Condition> buildWhen(){
            return build(when);
    }

    public me.snowdrop.istio.api.security.v1beta1.Condition buildWhen(int index){
            return this.when.get(index).build();
    }

    public me.snowdrop.istio.api.security.v1beta1.Condition buildFirstWhen(){
            return this.when.get(0).build();
    }

    public me.snowdrop.istio.api.security.v1beta1.Condition buildLastWhen(){
            return this.when.get(when.size() - 1).build();
    }

    public me.snowdrop.istio.api.security.v1beta1.Condition buildMatchingWhen(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            for (ConditionBuilder item: when) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingWhen(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            for (ConditionBuilder item: when) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withWhen(List<me.snowdrop.istio.api.security.v1beta1.Condition> when){
            if (this.when != null) { _visitables.get("when").removeAll(this.when);}
            if (when != null) {this.when = new ArrayList<ConditionBuilder>(); for (me.snowdrop.istio.api.security.v1beta1.Condition item : when){this.addToWhen(item);}} else { this.when = null;} return (A) this;
    }

    public A withWhen(me.snowdrop.istio.api.security.v1beta1.Condition... when){
            if (this.when != null) {this.when.clear();}
            if (when != null) {for (me.snowdrop.istio.api.security.v1beta1.Condition item :when){ this.addToWhen(item);}} return (A) this;
    }

    public Boolean hasWhen(){
            return when != null && !when.isEmpty();
    }

    public RuleFluent.WhenNested<A> addNewWhen(){
            return new WhenNestedImpl();
    }

    public RuleFluent.WhenNested<A> addNewWhenLike(me.snowdrop.istio.api.security.v1beta1.Condition item){
            return new WhenNestedImpl(-1, item);
    }

    public RuleFluent.WhenNested<A> setNewWhenLike(int index,me.snowdrop.istio.api.security.v1beta1.Condition item){
            return new WhenNestedImpl(index, item);
    }

    public RuleFluent.WhenNested<A> editWhen(int index){
            if (when.size() <= index) throw new RuntimeException("Can't edit when. Index exceeds size.");
            return setNewWhenLike(index, buildWhen(index));
    }

    public RuleFluent.WhenNested<A> editFirstWhen(){
            if (when.size() == 0) throw new RuntimeException("Can't edit first when. The list is empty.");
            return setNewWhenLike(0, buildWhen(0));
    }

    public RuleFluent.WhenNested<A> editLastWhen(){
            int index = when.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last when. The list is empty.");
            return setNewWhenLike(index, buildWhen(index));
    }

    public RuleFluent.WhenNested<A> editMatchingWhen(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<when.size();i++) { 
            if (predicate.apply(when.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching when. No match found.");
            return setNewWhenLike(index, buildWhen(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            RuleFluentImpl that = (RuleFluentImpl) o;
            if (from != null ? !from.equals(that.from) :that.from != null) return false;
            if (to != null ? !to.equals(that.to) :that.to != null) return false;
            if (when != null ? !when.equals(that.when) :that.when != null) return false;
            return true;
    }


    public class FromNestedImpl<N> extends FromFluentImpl<RuleFluent.FromNested<N>> implements RuleFluent.FromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final FromBuilder builder;
        private final int index;
    
            FromNestedImpl(int index,From item){
                    this.index = index;
                    this.builder = new FromBuilder(this, item);
            }
            FromNestedImpl(){
                    this.index = -1;
                    this.builder = new FromBuilder(this);
            }
    
    public N and(){
            return (N) RuleFluentImpl.this.setToFrom(index,builder.build());
    }
    public N endFrom(){
            return and();
    }

}
    public class ToNestedImpl<N> extends ToFluentImpl<RuleFluent.ToNested<N>> implements RuleFluent.ToNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ToBuilder builder;
        private final int index;
    
            ToNestedImpl(int index,To item){
                    this.index = index;
                    this.builder = new ToBuilder(this, item);
            }
            ToNestedImpl(){
                    this.index = -1;
                    this.builder = new ToBuilder(this);
            }
    
    public N and(){
            return (N) RuleFluentImpl.this.setToTo(index,builder.build());
    }
    public N endTo(){
            return and();
    }

}
    public class WhenNestedImpl<N> extends ConditionFluentImpl<RuleFluent.WhenNested<N>> implements RuleFluent.WhenNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConditionBuilder builder;
        private final int index;
    
            WhenNestedImpl(int index,me.snowdrop.istio.api.security.v1beta1.Condition item){
                    this.index = index;
                    this.builder = new ConditionBuilder(this, item);
            }
            WhenNestedImpl(){
                    this.index = -1;
                    this.builder = new ConditionBuilder(this);
            }
    
    public N and(){
            return (N) RuleFluentImpl.this.setToWhen(index,builder.build());
    }
    public N endWhen(){
            return and();
    }

}


}
