package me.snowdrop.istio.api.security.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Predicate;

public interface SourceFluent<A extends SourceFluent<A>> extends Fluent<A>{


    public A addToIpBlocks(int index,String item);
    public A setToIpBlocks(int index,String item);
    public A addToIpBlocks(String... items);
    public A addAllToIpBlocks(Collection<String> items);
    public A removeFromIpBlocks(String... items);
    public A removeAllFromIpBlocks(Collection<String> items);
    public List<String> getIpBlocks();
    public String getIpBlock(int index);
    public String getFirstIpBlock();
    public String getLastIpBlock();
    public String getMatchingIpBlock(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingIpBlock(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withIpBlocks(List<String> ipBlocks);
    public A withIpBlocks(String... ipBlocks);
    public Boolean hasIpBlocks();
    public A addNewIpBlock(String arg1);
    public A addNewIpBlock(StringBuilder arg1);
    public A addNewIpBlock(StringBuffer arg1);
    public A addToNamespaces(int index,String item);
    public A setToNamespaces(int index,String item);
    public A addToNamespaces(String... items);
    public A addAllToNamespaces(Collection<String> items);
    public A removeFromNamespaces(String... items);
    public A removeAllFromNamespaces(Collection<String> items);
    public List<String> getNamespaces();
    public String getNamespace(int index);
    public String getFirstNamespace();
    public String getLastNamespace();
    public String getMatchingNamespace(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingNamespace(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withNamespaces(List<String> namespaces);
    public A withNamespaces(String... namespaces);
    public Boolean hasNamespaces();
    public A addNewNamespace(String arg1);
    public A addNewNamespace(StringBuilder arg1);
    public A addNewNamespace(StringBuffer arg1);
    public A addToNotIpBlocks(int index,String item);
    public A setToNotIpBlocks(int index,String item);
    public A addToNotIpBlocks(String... items);
    public A addAllToNotIpBlocks(Collection<String> items);
    public A removeFromNotIpBlocks(String... items);
    public A removeAllFromNotIpBlocks(Collection<String> items);
    public List<String> getNotIpBlocks();
    public String getNotIpBlock(int index);
    public String getFirstNotIpBlock();
    public String getLastNotIpBlock();
    public String getMatchingNotIpBlock(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingNotIpBlock(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withNotIpBlocks(List<String> notIpBlocks);
    public A withNotIpBlocks(String... notIpBlocks);
    public Boolean hasNotIpBlocks();
    public A addNewNotIpBlock(String arg1);
    public A addNewNotIpBlock(StringBuilder arg1);
    public A addNewNotIpBlock(StringBuffer arg1);
    public A addToNotNamespaces(int index,String item);
    public A setToNotNamespaces(int index,String item);
    public A addToNotNamespaces(String... items);
    public A addAllToNotNamespaces(Collection<String> items);
    public A removeFromNotNamespaces(String... items);
    public A removeAllFromNotNamespaces(Collection<String> items);
    public List<String> getNotNamespaces();
    public String getNotNamespace(int index);
    public String getFirstNotNamespace();
    public String getLastNotNamespace();
    public String getMatchingNotNamespace(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingNotNamespace(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withNotNamespaces(List<String> notNamespaces);
    public A withNotNamespaces(String... notNamespaces);
    public Boolean hasNotNamespaces();
    public A addNewNotNamespace(String arg1);
    public A addNewNotNamespace(StringBuilder arg1);
    public A addNewNotNamespace(StringBuffer arg1);
    public A addToNotPrincipals(int index,String item);
    public A setToNotPrincipals(int index,String item);
    public A addToNotPrincipals(String... items);
    public A addAllToNotPrincipals(Collection<String> items);
    public A removeFromNotPrincipals(String... items);
    public A removeAllFromNotPrincipals(Collection<String> items);
    public List<String> getNotPrincipals();
    public String getNotPrincipal(int index);
    public String getFirstNotPrincipal();
    public String getLastNotPrincipal();
    public String getMatchingNotPrincipal(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingNotPrincipal(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withNotPrincipals(List<String> notPrincipals);
    public A withNotPrincipals(String... notPrincipals);
    public Boolean hasNotPrincipals();
    public A addNewNotPrincipal(String arg1);
    public A addNewNotPrincipal(StringBuilder arg1);
    public A addNewNotPrincipal(StringBuffer arg1);
    public A addToNotRequestPrincipals(int index,String item);
    public A setToNotRequestPrincipals(int index,String item);
    public A addToNotRequestPrincipals(String... items);
    public A addAllToNotRequestPrincipals(Collection<String> items);
    public A removeFromNotRequestPrincipals(String... items);
    public A removeAllFromNotRequestPrincipals(Collection<String> items);
    public List<String> getNotRequestPrincipals();
    public String getNotRequestPrincipal(int index);
    public String getFirstNotRequestPrincipal();
    public String getLastNotRequestPrincipal();
    public String getMatchingNotRequestPrincipal(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingNotRequestPrincipal(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withNotRequestPrincipals(List<String> notRequestPrincipals);
    public A withNotRequestPrincipals(String... notRequestPrincipals);
    public Boolean hasNotRequestPrincipals();
    public A addNewNotRequestPrincipal(String arg1);
    public A addNewNotRequestPrincipal(StringBuilder arg1);
    public A addNewNotRequestPrincipal(StringBuffer arg1);
    public A addToPrincipals(int index,String item);
    public A setToPrincipals(int index,String item);
    public A addToPrincipals(String... items);
    public A addAllToPrincipals(Collection<String> items);
    public A removeFromPrincipals(String... items);
    public A removeAllFromPrincipals(Collection<String> items);
    public List<String> getPrincipals();
    public String getPrincipal(int index);
    public String getFirstPrincipal();
    public String getLastPrincipal();
    public String getMatchingPrincipal(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingPrincipal(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withPrincipals(List<String> principals);
    public A withPrincipals(String... principals);
    public Boolean hasPrincipals();
    public A addNewPrincipal(String arg1);
    public A addNewPrincipal(StringBuilder arg1);
    public A addNewPrincipal(StringBuffer arg1);
    public A addToRequestPrincipals(int index,String item);
    public A setToRequestPrincipals(int index,String item);
    public A addToRequestPrincipals(String... items);
    public A addAllToRequestPrincipals(Collection<String> items);
    public A removeFromRequestPrincipals(String... items);
    public A removeAllFromRequestPrincipals(Collection<String> items);
    public List<String> getRequestPrincipals();
    public String getRequestPrincipal(int index);
    public String getFirstRequestPrincipal();
    public String getLastRequestPrincipal();
    public String getMatchingRequestPrincipal(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingRequestPrincipal(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withRequestPrincipals(List<String> requestPrincipals);
    public A withRequestPrincipals(String... requestPrincipals);
    public Boolean hasRequestPrincipals();
    public A addNewRequestPrincipal(String arg1);
    public A addNewRequestPrincipal(StringBuilder arg1);
    public A addNewRequestPrincipal(StringBuffer arg1);



}
