package me.snowdrop.istio.api.security.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class SourceFluentImpl<A extends SourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SourceFluent<A>{

    private List<String> ipBlocks;
    private List<String> namespaces;
    private List<String> notIpBlocks;
    private List<String> notNamespaces;
    private List<String> notPrincipals;
    private List<String> notRequestPrincipals;
    private List<String> principals;
    private List<String> requestPrincipals;

    public SourceFluentImpl(){
    }
    public SourceFluentImpl(Source instance){
            this.withIpBlocks(instance.getIpBlocks()); 
            this.withNamespaces(instance.getNamespaces()); 
            this.withNotIpBlocks(instance.getNotIpBlocks()); 
            this.withNotNamespaces(instance.getNotNamespaces()); 
            this.withNotPrincipals(instance.getNotPrincipals()); 
            this.withNotRequestPrincipals(instance.getNotRequestPrincipals()); 
            this.withPrincipals(instance.getPrincipals()); 
            this.withRequestPrincipals(instance.getRequestPrincipals()); 
    }

    public A addToIpBlocks(int index,String item){
            if (this.ipBlocks == null) {this.ipBlocks = new ArrayList<String>();}
            this.ipBlocks.add(index, item);
            return (A)this;
    }

    public A setToIpBlocks(int index,String item){
            if (this.ipBlocks == null) {this.ipBlocks = new ArrayList<String>();}
            this.ipBlocks.set(index, item); return (A)this;
    }

    public A addToIpBlocks(String... items){
            if (this.ipBlocks == null) {this.ipBlocks = new ArrayList<String>();}
            for (String item : items) {this.ipBlocks.add(item);} return (A)this;
    }

    public A addAllToIpBlocks(Collection<String> items){
            if (this.ipBlocks == null) {this.ipBlocks = new ArrayList<String>();}
            for (String item : items) {this.ipBlocks.add(item);} return (A)this;
    }

    public A removeFromIpBlocks(String... items){
            for (String item : items) {if (this.ipBlocks!= null){ this.ipBlocks.remove(item);}} return (A)this;
    }

    public A removeAllFromIpBlocks(Collection<String> items){
            for (String item : items) {if (this.ipBlocks!= null){ this.ipBlocks.remove(item);}} return (A)this;
    }

    public List<String> getIpBlocks(){
            return this.ipBlocks;
    }

    public String getIpBlock(int index){
            return this.ipBlocks.get(index);
    }

    public String getFirstIpBlock(){
            return this.ipBlocks.get(0);
    }

    public String getLastIpBlock(){
            return this.ipBlocks.get(ipBlocks.size() - 1);
    }

    public String getMatchingIpBlock(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: ipBlocks) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingIpBlock(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: ipBlocks) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withIpBlocks(List<String> ipBlocks){
            if (this.ipBlocks != null) { _visitables.get("ipBlocks").removeAll(this.ipBlocks);}
            if (ipBlocks != null) {this.ipBlocks = new ArrayList<String>(); for (String item : ipBlocks){this.addToIpBlocks(item);}} else { this.ipBlocks = null;} return (A) this;
    }

    public A withIpBlocks(String... ipBlocks){
            if (this.ipBlocks != null) {this.ipBlocks.clear();}
            if (ipBlocks != null) {for (String item :ipBlocks){ this.addToIpBlocks(item);}} return (A) this;
    }

    public Boolean hasIpBlocks(){
            return ipBlocks != null && !ipBlocks.isEmpty();
    }

    public A addNewIpBlock(String arg1){
            return (A)addToIpBlocks(new String(arg1));
    }

    public A addNewIpBlock(StringBuilder arg1){
            return (A)addToIpBlocks(new String(arg1));
    }

    public A addNewIpBlock(StringBuffer arg1){
            return (A)addToIpBlocks(new String(arg1));
    }

    public A addToNamespaces(int index,String item){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            this.namespaces.add(index, item);
            return (A)this;
    }

    public A setToNamespaces(int index,String item){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            this.namespaces.set(index, item); return (A)this;
    }

    public A addToNamespaces(String... items){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A addAllToNamespaces(Collection<String> items){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A removeFromNamespaces(String... items){
            for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public A removeAllFromNamespaces(Collection<String> items){
            for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public List<String> getNamespaces(){
            return this.namespaces;
    }

    public String getNamespace(int index){
            return this.namespaces.get(index);
    }

    public String getFirstNamespace(){
            return this.namespaces.get(0);
    }

    public String getLastNamespace(){
            return this.namespaces.get(namespaces.size() - 1);
    }

    public String getMatchingNamespace(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: namespaces) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNamespace(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: namespaces) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNamespaces(List<String> namespaces){
            if (this.namespaces != null) { _visitables.get("namespaces").removeAll(this.namespaces);}
            if (namespaces != null) {this.namespaces = new ArrayList<String>(); for (String item : namespaces){this.addToNamespaces(item);}} else { this.namespaces = null;} return (A) this;
    }

    public A withNamespaces(String... namespaces){
            if (this.namespaces != null) {this.namespaces.clear();}
            if (namespaces != null) {for (String item :namespaces){ this.addToNamespaces(item);}} return (A) this;
    }

    public Boolean hasNamespaces(){
            return namespaces != null && !namespaces.isEmpty();
    }

    public A addNewNamespace(String arg1){
            return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(StringBuilder arg1){
            return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(StringBuffer arg1){
            return (A)addToNamespaces(new String(arg1));
    }

    public A addToNotIpBlocks(int index,String item){
            if (this.notIpBlocks == null) {this.notIpBlocks = new ArrayList<String>();}
            this.notIpBlocks.add(index, item);
            return (A)this;
    }

    public A setToNotIpBlocks(int index,String item){
            if (this.notIpBlocks == null) {this.notIpBlocks = new ArrayList<String>();}
            this.notIpBlocks.set(index, item); return (A)this;
    }

    public A addToNotIpBlocks(String... items){
            if (this.notIpBlocks == null) {this.notIpBlocks = new ArrayList<String>();}
            for (String item : items) {this.notIpBlocks.add(item);} return (A)this;
    }

    public A addAllToNotIpBlocks(Collection<String> items){
            if (this.notIpBlocks == null) {this.notIpBlocks = new ArrayList<String>();}
            for (String item : items) {this.notIpBlocks.add(item);} return (A)this;
    }

    public A removeFromNotIpBlocks(String... items){
            for (String item : items) {if (this.notIpBlocks!= null){ this.notIpBlocks.remove(item);}} return (A)this;
    }

    public A removeAllFromNotIpBlocks(Collection<String> items){
            for (String item : items) {if (this.notIpBlocks!= null){ this.notIpBlocks.remove(item);}} return (A)this;
    }

    public List<String> getNotIpBlocks(){
            return this.notIpBlocks;
    }

    public String getNotIpBlock(int index){
            return this.notIpBlocks.get(index);
    }

    public String getFirstNotIpBlock(){
            return this.notIpBlocks.get(0);
    }

    public String getLastNotIpBlock(){
            return this.notIpBlocks.get(notIpBlocks.size() - 1);
    }

    public String getMatchingNotIpBlock(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notIpBlocks) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNotIpBlock(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notIpBlocks) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNotIpBlocks(List<String> notIpBlocks){
            if (this.notIpBlocks != null) { _visitables.get("notIpBlocks").removeAll(this.notIpBlocks);}
            if (notIpBlocks != null) {this.notIpBlocks = new ArrayList<String>(); for (String item : notIpBlocks){this.addToNotIpBlocks(item);}} else { this.notIpBlocks = null;} return (A) this;
    }

    public A withNotIpBlocks(String... notIpBlocks){
            if (this.notIpBlocks != null) {this.notIpBlocks.clear();}
            if (notIpBlocks != null) {for (String item :notIpBlocks){ this.addToNotIpBlocks(item);}} return (A) this;
    }

    public Boolean hasNotIpBlocks(){
            return notIpBlocks != null && !notIpBlocks.isEmpty();
    }

    public A addNewNotIpBlock(String arg1){
            return (A)addToNotIpBlocks(new String(arg1));
    }

    public A addNewNotIpBlock(StringBuilder arg1){
            return (A)addToNotIpBlocks(new String(arg1));
    }

    public A addNewNotIpBlock(StringBuffer arg1){
            return (A)addToNotIpBlocks(new String(arg1));
    }

    public A addToNotNamespaces(int index,String item){
            if (this.notNamespaces == null) {this.notNamespaces = new ArrayList<String>();}
            this.notNamespaces.add(index, item);
            return (A)this;
    }

    public A setToNotNamespaces(int index,String item){
            if (this.notNamespaces == null) {this.notNamespaces = new ArrayList<String>();}
            this.notNamespaces.set(index, item); return (A)this;
    }

    public A addToNotNamespaces(String... items){
            if (this.notNamespaces == null) {this.notNamespaces = new ArrayList<String>();}
            for (String item : items) {this.notNamespaces.add(item);} return (A)this;
    }

    public A addAllToNotNamespaces(Collection<String> items){
            if (this.notNamespaces == null) {this.notNamespaces = new ArrayList<String>();}
            for (String item : items) {this.notNamespaces.add(item);} return (A)this;
    }

    public A removeFromNotNamespaces(String... items){
            for (String item : items) {if (this.notNamespaces!= null){ this.notNamespaces.remove(item);}} return (A)this;
    }

    public A removeAllFromNotNamespaces(Collection<String> items){
            for (String item : items) {if (this.notNamespaces!= null){ this.notNamespaces.remove(item);}} return (A)this;
    }

    public List<String> getNotNamespaces(){
            return this.notNamespaces;
    }

    public String getNotNamespace(int index){
            return this.notNamespaces.get(index);
    }

    public String getFirstNotNamespace(){
            return this.notNamespaces.get(0);
    }

    public String getLastNotNamespace(){
            return this.notNamespaces.get(notNamespaces.size() - 1);
    }

    public String getMatchingNotNamespace(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notNamespaces) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNotNamespace(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notNamespaces) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNotNamespaces(List<String> notNamespaces){
            if (this.notNamespaces != null) { _visitables.get("notNamespaces").removeAll(this.notNamespaces);}
            if (notNamespaces != null) {this.notNamespaces = new ArrayList<String>(); for (String item : notNamespaces){this.addToNotNamespaces(item);}} else { this.notNamespaces = null;} return (A) this;
    }

    public A withNotNamespaces(String... notNamespaces){
            if (this.notNamespaces != null) {this.notNamespaces.clear();}
            if (notNamespaces != null) {for (String item :notNamespaces){ this.addToNotNamespaces(item);}} return (A) this;
    }

    public Boolean hasNotNamespaces(){
            return notNamespaces != null && !notNamespaces.isEmpty();
    }

    public A addNewNotNamespace(String arg1){
            return (A)addToNotNamespaces(new String(arg1));
    }

    public A addNewNotNamespace(StringBuilder arg1){
            return (A)addToNotNamespaces(new String(arg1));
    }

    public A addNewNotNamespace(StringBuffer arg1){
            return (A)addToNotNamespaces(new String(arg1));
    }

    public A addToNotPrincipals(int index,String item){
            if (this.notPrincipals == null) {this.notPrincipals = new ArrayList<String>();}
            this.notPrincipals.add(index, item);
            return (A)this;
    }

    public A setToNotPrincipals(int index,String item){
            if (this.notPrincipals == null) {this.notPrincipals = new ArrayList<String>();}
            this.notPrincipals.set(index, item); return (A)this;
    }

    public A addToNotPrincipals(String... items){
            if (this.notPrincipals == null) {this.notPrincipals = new ArrayList<String>();}
            for (String item : items) {this.notPrincipals.add(item);} return (A)this;
    }

    public A addAllToNotPrincipals(Collection<String> items){
            if (this.notPrincipals == null) {this.notPrincipals = new ArrayList<String>();}
            for (String item : items) {this.notPrincipals.add(item);} return (A)this;
    }

    public A removeFromNotPrincipals(String... items){
            for (String item : items) {if (this.notPrincipals!= null){ this.notPrincipals.remove(item);}} return (A)this;
    }

    public A removeAllFromNotPrincipals(Collection<String> items){
            for (String item : items) {if (this.notPrincipals!= null){ this.notPrincipals.remove(item);}} return (A)this;
    }

    public List<String> getNotPrincipals(){
            return this.notPrincipals;
    }

    public String getNotPrincipal(int index){
            return this.notPrincipals.get(index);
    }

    public String getFirstNotPrincipal(){
            return this.notPrincipals.get(0);
    }

    public String getLastNotPrincipal(){
            return this.notPrincipals.get(notPrincipals.size() - 1);
    }

    public String getMatchingNotPrincipal(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notPrincipals) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNotPrincipal(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notPrincipals) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNotPrincipals(List<String> notPrincipals){
            if (this.notPrincipals != null) { _visitables.get("notPrincipals").removeAll(this.notPrincipals);}
            if (notPrincipals != null) {this.notPrincipals = new ArrayList<String>(); for (String item : notPrincipals){this.addToNotPrincipals(item);}} else { this.notPrincipals = null;} return (A) this;
    }

    public A withNotPrincipals(String... notPrincipals){
            if (this.notPrincipals != null) {this.notPrincipals.clear();}
            if (notPrincipals != null) {for (String item :notPrincipals){ this.addToNotPrincipals(item);}} return (A) this;
    }

    public Boolean hasNotPrincipals(){
            return notPrincipals != null && !notPrincipals.isEmpty();
    }

    public A addNewNotPrincipal(String arg1){
            return (A)addToNotPrincipals(new String(arg1));
    }

    public A addNewNotPrincipal(StringBuilder arg1){
            return (A)addToNotPrincipals(new String(arg1));
    }

    public A addNewNotPrincipal(StringBuffer arg1){
            return (A)addToNotPrincipals(new String(arg1));
    }

    public A addToNotRequestPrincipals(int index,String item){
            if (this.notRequestPrincipals == null) {this.notRequestPrincipals = new ArrayList<String>();}
            this.notRequestPrincipals.add(index, item);
            return (A)this;
    }

    public A setToNotRequestPrincipals(int index,String item){
            if (this.notRequestPrincipals == null) {this.notRequestPrincipals = new ArrayList<String>();}
            this.notRequestPrincipals.set(index, item); return (A)this;
    }

    public A addToNotRequestPrincipals(String... items){
            if (this.notRequestPrincipals == null) {this.notRequestPrincipals = new ArrayList<String>();}
            for (String item : items) {this.notRequestPrincipals.add(item);} return (A)this;
    }

    public A addAllToNotRequestPrincipals(Collection<String> items){
            if (this.notRequestPrincipals == null) {this.notRequestPrincipals = new ArrayList<String>();}
            for (String item : items) {this.notRequestPrincipals.add(item);} return (A)this;
    }

    public A removeFromNotRequestPrincipals(String... items){
            for (String item : items) {if (this.notRequestPrincipals!= null){ this.notRequestPrincipals.remove(item);}} return (A)this;
    }

    public A removeAllFromNotRequestPrincipals(Collection<String> items){
            for (String item : items) {if (this.notRequestPrincipals!= null){ this.notRequestPrincipals.remove(item);}} return (A)this;
    }

    public List<String> getNotRequestPrincipals(){
            return this.notRequestPrincipals;
    }

    public String getNotRequestPrincipal(int index){
            return this.notRequestPrincipals.get(index);
    }

    public String getFirstNotRequestPrincipal(){
            return this.notRequestPrincipals.get(0);
    }

    public String getLastNotRequestPrincipal(){
            return this.notRequestPrincipals.get(notRequestPrincipals.size() - 1);
    }

    public String getMatchingNotRequestPrincipal(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notRequestPrincipals) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNotRequestPrincipal(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notRequestPrincipals) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNotRequestPrincipals(List<String> notRequestPrincipals){
            if (this.notRequestPrincipals != null) { _visitables.get("notRequestPrincipals").removeAll(this.notRequestPrincipals);}
            if (notRequestPrincipals != null) {this.notRequestPrincipals = new ArrayList<String>(); for (String item : notRequestPrincipals){this.addToNotRequestPrincipals(item);}} else { this.notRequestPrincipals = null;} return (A) this;
    }

    public A withNotRequestPrincipals(String... notRequestPrincipals){
            if (this.notRequestPrincipals != null) {this.notRequestPrincipals.clear();}
            if (notRequestPrincipals != null) {for (String item :notRequestPrincipals){ this.addToNotRequestPrincipals(item);}} return (A) this;
    }

    public Boolean hasNotRequestPrincipals(){
            return notRequestPrincipals != null && !notRequestPrincipals.isEmpty();
    }

    public A addNewNotRequestPrincipal(String arg1){
            return (A)addToNotRequestPrincipals(new String(arg1));
    }

    public A addNewNotRequestPrincipal(StringBuilder arg1){
            return (A)addToNotRequestPrincipals(new String(arg1));
    }

    public A addNewNotRequestPrincipal(StringBuffer arg1){
            return (A)addToNotRequestPrincipals(new String(arg1));
    }

    public A addToPrincipals(int index,String item){
            if (this.principals == null) {this.principals = new ArrayList<String>();}
            this.principals.add(index, item);
            return (A)this;
    }

    public A setToPrincipals(int index,String item){
            if (this.principals == null) {this.principals = new ArrayList<String>();}
            this.principals.set(index, item); return (A)this;
    }

    public A addToPrincipals(String... items){
            if (this.principals == null) {this.principals = new ArrayList<String>();}
            for (String item : items) {this.principals.add(item);} return (A)this;
    }

    public A addAllToPrincipals(Collection<String> items){
            if (this.principals == null) {this.principals = new ArrayList<String>();}
            for (String item : items) {this.principals.add(item);} return (A)this;
    }

    public A removeFromPrincipals(String... items){
            for (String item : items) {if (this.principals!= null){ this.principals.remove(item);}} return (A)this;
    }

    public A removeAllFromPrincipals(Collection<String> items){
            for (String item : items) {if (this.principals!= null){ this.principals.remove(item);}} return (A)this;
    }

    public List<String> getPrincipals(){
            return this.principals;
    }

    public String getPrincipal(int index){
            return this.principals.get(index);
    }

    public String getFirstPrincipal(){
            return this.principals.get(0);
    }

    public String getLastPrincipal(){
            return this.principals.get(principals.size() - 1);
    }

    public String getMatchingPrincipal(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: principals) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingPrincipal(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: principals) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withPrincipals(List<String> principals){
            if (this.principals != null) { _visitables.get("principals").removeAll(this.principals);}
            if (principals != null) {this.principals = new ArrayList<String>(); for (String item : principals){this.addToPrincipals(item);}} else { this.principals = null;} return (A) this;
    }

    public A withPrincipals(String... principals){
            if (this.principals != null) {this.principals.clear();}
            if (principals != null) {for (String item :principals){ this.addToPrincipals(item);}} return (A) this;
    }

    public Boolean hasPrincipals(){
            return principals != null && !principals.isEmpty();
    }

    public A addNewPrincipal(String arg1){
            return (A)addToPrincipals(new String(arg1));
    }

    public A addNewPrincipal(StringBuilder arg1){
            return (A)addToPrincipals(new String(arg1));
    }

    public A addNewPrincipal(StringBuffer arg1){
            return (A)addToPrincipals(new String(arg1));
    }

    public A addToRequestPrincipals(int index,String item){
            if (this.requestPrincipals == null) {this.requestPrincipals = new ArrayList<String>();}
            this.requestPrincipals.add(index, item);
            return (A)this;
    }

    public A setToRequestPrincipals(int index,String item){
            if (this.requestPrincipals == null) {this.requestPrincipals = new ArrayList<String>();}
            this.requestPrincipals.set(index, item); return (A)this;
    }

    public A addToRequestPrincipals(String... items){
            if (this.requestPrincipals == null) {this.requestPrincipals = new ArrayList<String>();}
            for (String item : items) {this.requestPrincipals.add(item);} return (A)this;
    }

    public A addAllToRequestPrincipals(Collection<String> items){
            if (this.requestPrincipals == null) {this.requestPrincipals = new ArrayList<String>();}
            for (String item : items) {this.requestPrincipals.add(item);} return (A)this;
    }

    public A removeFromRequestPrincipals(String... items){
            for (String item : items) {if (this.requestPrincipals!= null){ this.requestPrincipals.remove(item);}} return (A)this;
    }

    public A removeAllFromRequestPrincipals(Collection<String> items){
            for (String item : items) {if (this.requestPrincipals!= null){ this.requestPrincipals.remove(item);}} return (A)this;
    }

    public List<String> getRequestPrincipals(){
            return this.requestPrincipals;
    }

    public String getRequestPrincipal(int index){
            return this.requestPrincipals.get(index);
    }

    public String getFirstRequestPrincipal(){
            return this.requestPrincipals.get(0);
    }

    public String getLastRequestPrincipal(){
            return this.requestPrincipals.get(requestPrincipals.size() - 1);
    }

    public String getMatchingRequestPrincipal(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: requestPrincipals) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingRequestPrincipal(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: requestPrincipals) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRequestPrincipals(List<String> requestPrincipals){
            if (this.requestPrincipals != null) { _visitables.get("requestPrincipals").removeAll(this.requestPrincipals);}
            if (requestPrincipals != null) {this.requestPrincipals = new ArrayList<String>(); for (String item : requestPrincipals){this.addToRequestPrincipals(item);}} else { this.requestPrincipals = null;} return (A) this;
    }

    public A withRequestPrincipals(String... requestPrincipals){
            if (this.requestPrincipals != null) {this.requestPrincipals.clear();}
            if (requestPrincipals != null) {for (String item :requestPrincipals){ this.addToRequestPrincipals(item);}} return (A) this;
    }

    public Boolean hasRequestPrincipals(){
            return requestPrincipals != null && !requestPrincipals.isEmpty();
    }

    public A addNewRequestPrincipal(String arg1){
            return (A)addToRequestPrincipals(new String(arg1));
    }

    public A addNewRequestPrincipal(StringBuilder arg1){
            return (A)addToRequestPrincipals(new String(arg1));
    }

    public A addNewRequestPrincipal(StringBuffer arg1){
            return (A)addToRequestPrincipals(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SourceFluentImpl that = (SourceFluentImpl) o;
            if (ipBlocks != null ? !ipBlocks.equals(that.ipBlocks) :that.ipBlocks != null) return false;
            if (namespaces != null ? !namespaces.equals(that.namespaces) :that.namespaces != null) return false;
            if (notIpBlocks != null ? !notIpBlocks.equals(that.notIpBlocks) :that.notIpBlocks != null) return false;
            if (notNamespaces != null ? !notNamespaces.equals(that.notNamespaces) :that.notNamespaces != null) return false;
            if (notPrincipals != null ? !notPrincipals.equals(that.notPrincipals) :that.notPrincipals != null) return false;
            if (notRequestPrincipals != null ? !notRequestPrincipals.equals(that.notRequestPrincipals) :that.notRequestPrincipals != null) return false;
            if (principals != null ? !principals.equals(that.principals) :that.principals != null) return false;
            if (requestPrincipals != null ? !requestPrincipals.equals(that.requestPrincipals) :that.requestPrincipals != null) return false;
            return true;
    }




}
