package me.snowdrop.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ToBuilder extends ToFluentImpl<ToBuilder> implements VisitableBuilder<To,ToBuilder>{

    ToFluent<?> fluent;
    Boolean validationEnabled;

    public ToBuilder(){
            this(true);
    }
    public ToBuilder(Boolean validationEnabled){
            this(new To(), validationEnabled);
    }
    public ToBuilder(ToFluent<?> fluent){
            this(fluent, true);
    }
    public ToBuilder(ToFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new To(), validationEnabled);
    }
    public ToBuilder(ToFluent<?> fluent,To instance){
            this(fluent, instance, true);
    }
    public ToBuilder(ToFluent<?> fluent,To instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withOperation(instance.getOperation()); 
            this.validationEnabled = validationEnabled; 
    }
    public ToBuilder(To instance){
            this(instance,true);
    }
    public ToBuilder(To instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withOperation(instance.getOperation()); 
            this.validationEnabled = validationEnabled; 
    }

    public To build(){
            To buildable = new To(fluent.getOperation());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ToBuilder that = (ToBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
