
package me.snowdrop.istio.api.type.v1beta1;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "matchLabels"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class WorkloadSelector implements Serializable
{

    /**
     * 
     */
    @JsonProperty("matchLabels")
    @JsonPropertyDescription("")
    private Map<String, String> matchLabels;
    private final static long serialVersionUID = 9159326958618725434L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public WorkloadSelector() {
    }

    /**
     * 
     * @param matchLabels
     */
    public WorkloadSelector(Map<String, String> matchLabels) {
        super();
        this.matchLabels = matchLabels;
    }

    /**
     * 
     */
    public Map<String, String> getMatchLabels() {
        return matchLabels;
    }

    /**
     * 
     */
    public void setMatchLabels(Map<String, String> matchLabels) {
        this.matchLabels = matchLabels;
    }

}
