
package me.snowdrop.istio.mixer.adapter.bypass;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Any;
import me.snowdrop.istio.api.internal.MixerAdapter;
import me.snowdrop.istio.api.policy.v1beta1.HandlerParams;


/**
 * 
 */
@MixerAdapter(compiledAdapter = "bypass")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "backendAddress",
    "params",
    "sessionBased"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Bypass implements Serializable, HandlerParams
{

    /**
     * 
     */
    @JsonProperty("backendAddress")
    @JsonPropertyDescription("")
    private String backendAddress;
    /**
     * 
     */
    @JsonProperty("params")
    @JsonPropertyDescription("")
    private Any params;
    /**
     * 
     */
    @JsonProperty("sessionBased")
    @JsonPropertyDescription("")
    private Boolean sessionBased;
    private final static long serialVersionUID = 3805446521324107508L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Bypass() {
    }

    /**
     * 
     * @param sessionBased
     * @param params
     * @param backendAddress
     */
    public Bypass(String backendAddress, Any params, Boolean sessionBased) {
        super();
        this.backendAddress = backendAddress;
        this.params = params;
        this.sessionBased = sessionBased;
    }

    /**
     * 
     */
    public String getBackendAddress() {
        return backendAddress;
    }

    /**
     * 
     */
    public void setBackendAddress(String backendAddress) {
        this.backendAddress = backendAddress;
    }

    /**
     * 
     */
    public Any getParams() {
        return params;
    }

    /**
     * 
     */
    public void setParams(Any params) {
        this.params = params;
    }

    /**
     * 
     */
    public Boolean getSessionBased() {
        return sessionBased;
    }

    /**
     * 
     */
    public void setSessionBased(Boolean sessionBased) {
        this.sessionBased = sessionBased;
    }

}
