package me.snowdrop.istio.mixer.adapter.bypass;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BypassBuilder extends BypassFluentImpl<BypassBuilder> implements VisitableBuilder<Bypass,BypassBuilder>{

    BypassFluent<?> fluent;
    Boolean validationEnabled;

    public BypassBuilder(){
            this(true);
    }
    public BypassBuilder(Boolean validationEnabled){
            this(new Bypass(), validationEnabled);
    }
    public BypassBuilder(BypassFluent<?> fluent){
            this(fluent, true);
    }
    public BypassBuilder(BypassFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Bypass(), validationEnabled);
    }
    public BypassBuilder(BypassFluent<?> fluent,Bypass instance){
            this(fluent, instance, true);
    }
    public BypassBuilder(BypassFluent<?> fluent,Bypass instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBackendAddress(instance.getBackendAddress()); 
            fluent.withParams(instance.getParams()); 
            fluent.withSessionBased(instance.getSessionBased()); 
            this.validationEnabled = validationEnabled; 
    }
    public BypassBuilder(Bypass instance){
            this(instance,true);
    }
    public BypassBuilder(Bypass instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBackendAddress(instance.getBackendAddress()); 
            this.withParams(instance.getParams()); 
            this.withSessionBased(instance.getSessionBased()); 
            this.validationEnabled = validationEnabled; 
    }

    public Bypass build(){
            Bypass buildable = new Bypass(fluent.getBackendAddress(),fluent.getParams(),fluent.isSessionBased());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BypassBuilder that = (BypassBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
