
package me.snowdrop.istio.mixer.adapter.circonus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.internal.MixerAdapter;
import me.snowdrop.istio.api.policy.v1beta1.HandlerParams;


/**
 * 
 */
@MixerAdapter(compiledAdapter = "circonus")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "metrics",
    "submissionInterval",
    "submissionUrl"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Circonus implements Serializable, HandlerParams
{

    /**
     * 
     */
    @JsonProperty("metrics")
    @JsonPropertyDescription("")
    private List<MetricInfo> metrics = new ArrayList<MetricInfo>();
    /**
     * 
     */
    @JsonProperty("submissionInterval")
    @JsonPropertyDescription("")
    private Integer submissionInterval;
    /**
     * 
     */
    @JsonProperty("submissionUrl")
    @JsonPropertyDescription("")
    private String submissionUrl;
    private final static long serialVersionUID = 4327269085993985L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Circonus() {
    }

    /**
     * 
     * @param submissionInterval
     * @param metrics
     * @param submissionUrl
     */
    public Circonus(List<MetricInfo> metrics, Integer submissionInterval, String submissionUrl) {
        super();
        this.metrics = metrics;
        this.submissionInterval = submissionInterval;
        this.submissionUrl = submissionUrl;
    }

    /**
     * 
     */
    public List<MetricInfo> getMetrics() {
        return metrics;
    }

    /**
     * 
     */
    public void setMetrics(List<MetricInfo> metrics) {
        this.metrics = metrics;
    }

    /**
     * 
     */
    public Integer getSubmissionInterval() {
        return submissionInterval;
    }

    /**
     * 
     */
    public void setSubmissionInterval(Integer submissionInterval) {
        this.submissionInterval = submissionInterval;
    }

    /**
     * 
     */
    public String getSubmissionUrl() {
        return submissionUrl;
    }

    /**
     * 
     */
    public void setSubmissionUrl(String submissionUrl) {
        this.submissionUrl = submissionUrl;
    }

}
