package me.snowdrop.istio.mixer.adapter.circonus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CirconusBuilder extends CirconusFluentImpl<CirconusBuilder> implements VisitableBuilder<Circonus,CirconusBuilder>{

    CirconusFluent<?> fluent;
    Boolean validationEnabled;

    public CirconusBuilder(){
            this(true);
    }
    public CirconusBuilder(Boolean validationEnabled){
            this(new Circonus(), validationEnabled);
    }
    public CirconusBuilder(CirconusFluent<?> fluent){
            this(fluent, true);
    }
    public CirconusBuilder(CirconusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Circonus(), validationEnabled);
    }
    public CirconusBuilder(CirconusFluent<?> fluent,Circonus instance){
            this(fluent, instance, true);
    }
    public CirconusBuilder(CirconusFluent<?> fluent,Circonus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMetrics(instance.getMetrics()); 
            fluent.withSubmissionInterval(instance.getSubmissionInterval()); 
            fluent.withSubmissionUrl(instance.getSubmissionUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public CirconusBuilder(Circonus instance){
            this(instance,true);
    }
    public CirconusBuilder(Circonus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMetrics(instance.getMetrics()); 
            this.withSubmissionInterval(instance.getSubmissionInterval()); 
            this.withSubmissionUrl(instance.getSubmissionUrl()); 
            this.validationEnabled = validationEnabled; 
    }

    public Circonus build(){
            Circonus buildable = new Circonus(fluent.getMetrics(),fluent.getSubmissionInterval(),fluent.getSubmissionUrl());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CirconusBuilder that = (CirconusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
