package me.snowdrop.istio.mixer.adapter.circonus;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface CirconusFluent<A extends CirconusFluent<A>> extends Fluent<A>{


    public A addToMetrics(int index,MetricInfo item);
    public A setToMetrics(int index,MetricInfo item);
    public A addToMetrics(MetricInfo... items);
    public A addAllToMetrics(Collection<MetricInfo> items);
    public A removeFromMetrics(MetricInfo... items);
    public A removeAllFromMetrics(Collection<MetricInfo> items);
    public A removeMatchingFromMetrics(io.fabric8.kubernetes.api.builder.Predicate<MetricInfoBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildMetrics instead.
 * @return The buildable object.
 */
@Deprecated public List<MetricInfo> getMetrics();
    public List<MetricInfo> buildMetrics();
    public MetricInfo buildMetric(int index);
    public MetricInfo buildFirstMetric();
    public MetricInfo buildLastMetric();
    public MetricInfo buildMatchingMetric(io.fabric8.kubernetes.api.builder.Predicate<MetricInfoBuilder> predicate);
    public Boolean hasMatchingMetric(io.fabric8.kubernetes.api.builder.Predicate<MetricInfoBuilder> predicate);
    public A withMetrics(List<MetricInfo> metrics);
    public A withMetrics(MetricInfo... metrics);
    public Boolean hasMetrics();
    public CirconusFluent.MetricsNested<A> addNewMetric();
    public CirconusFluent.MetricsNested<A> addNewMetricLike(MetricInfo item);
    public CirconusFluent.MetricsNested<A> setNewMetricLike(int index,MetricInfo item);
    public CirconusFluent.MetricsNested<A> editMetric(int index);
    public CirconusFluent.MetricsNested<A> editFirstMetric();
    public CirconusFluent.MetricsNested<A> editLastMetric();
    public CirconusFluent.MetricsNested<A> editMatchingMetric(io.fabric8.kubernetes.api.builder.Predicate<MetricInfoBuilder> predicate);
    public Integer getSubmissionInterval();
    public A withSubmissionInterval(Integer submissionInterval);
    public Boolean hasSubmissionInterval();
    public String getSubmissionUrl();
    public A withSubmissionUrl(String submissionUrl);
    public Boolean hasSubmissionUrl();
    public A withNewSubmissionUrl(String arg1);
    public A withNewSubmissionUrl(StringBuilder arg1);
    public A withNewSubmissionUrl(StringBuffer arg1);

    public interface MetricsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,MetricInfoFluent<CirconusFluent.MetricsNested<N>>{

        
    public N and();    public N endMetric();
}


}
