package me.snowdrop.istio.mixer.adapter.circonus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MetricInfoBuilder extends MetricInfoFluentImpl<MetricInfoBuilder> implements VisitableBuilder<MetricInfo,MetricInfoBuilder>{

    MetricInfoFluent<?> fluent;
    Boolean validationEnabled;

    public MetricInfoBuilder(){
            this(true);
    }
    public MetricInfoBuilder(Boolean validationEnabled){
            this(new MetricInfo(), validationEnabled);
    }
    public MetricInfoBuilder(MetricInfoFluent<?> fluent){
            this(fluent, true);
    }
    public MetricInfoBuilder(MetricInfoFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MetricInfo(), validationEnabled);
    }
    public MetricInfoBuilder(MetricInfoFluent<?> fluent,MetricInfo instance){
            this(fluent, instance, true);
    }
    public MetricInfoBuilder(MetricInfoFluent<?> fluent,MetricInfo instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public MetricInfoBuilder(MetricInfo instance){
            this(instance,true);
    }
    public MetricInfoBuilder(MetricInfo instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }

    public MetricInfo build(){
            MetricInfo buildable = new MetricInfo(fluent.getName(),fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MetricInfoBuilder that = (MetricInfoBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
