
package me.snowdrop.istio.mixer.adapter.cloudwatch;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.internal.MixerAdapter;
import me.snowdrop.istio.api.policy.v1beta1.HandlerParams;


/**
 * 
 */
@MixerAdapter(compiledAdapter = "cloudwatch")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "logGroupName",
    "logStreamName",
    "logs",
    "metricInfo",
    "namespace"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Cloudwatch implements Serializable, HandlerParams
{

    /**
     * 
     */
    @JsonProperty("logGroupName")
    @JsonPropertyDescription("")
    private java.lang.String logGroupName;
    /**
     * 
     */
    @JsonProperty("logStreamName")
    @JsonPropertyDescription("")
    private java.lang.String logStreamName;
    /**
     * 
     */
    @JsonProperty("logs")
    @JsonPropertyDescription("")
    private Map<String, LogInfo> logs;
    /**
     * 
     */
    @JsonProperty("metricInfo")
    @JsonPropertyDescription("")
    private Map<String, MetricDatum> metricInfo;
    /**
     * 
     */
    @JsonProperty("namespace")
    @JsonPropertyDescription("")
    private java.lang.String namespace;
    private final static long serialVersionUID = -1442698068688336345L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Cloudwatch() {
    }

    /**
     * 
     * @param logGroupName
     * @param logStreamName
     * @param metricInfo
     * @param namespace
     * @param logs
     */
    public Cloudwatch(java.lang.String logGroupName, java.lang.String logStreamName, Map<String, LogInfo> logs, Map<String, MetricDatum> metricInfo, java.lang.String namespace) {
        super();
        this.logGroupName = logGroupName;
        this.logStreamName = logStreamName;
        this.logs = logs;
        this.metricInfo = metricInfo;
        this.namespace = namespace;
    }

    /**
     * 
     */
    public java.lang.String getLogGroupName() {
        return logGroupName;
    }

    /**
     * 
     */
    public void setLogGroupName(java.lang.String logGroupName) {
        this.logGroupName = logGroupName;
    }

    /**
     * 
     */
    public java.lang.String getLogStreamName() {
        return logStreamName;
    }

    /**
     * 
     */
    public void setLogStreamName(java.lang.String logStreamName) {
        this.logStreamName = logStreamName;
    }

    /**
     * 
     */
    public Map<String, LogInfo> getLogs() {
        return logs;
    }

    /**
     * 
     */
    public void setLogs(Map<String, LogInfo> logs) {
        this.logs = logs;
    }

    /**
     * 
     */
    public Map<String, MetricDatum> getMetricInfo() {
        return metricInfo;
    }

    /**
     * 
     */
    public void setMetricInfo(Map<String, MetricDatum> metricInfo) {
        this.metricInfo = metricInfo;
    }

    /**
     * 
     */
    public java.lang.String getNamespace() {
        return namespace;
    }

    /**
     * 
     */
    public void setNamespace(java.lang.String namespace) {
        this.namespace = namespace;
    }

}
