package me.snowdrop.istio.mixer.adapter.cloudwatch;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CloudwatchBuilder extends CloudwatchFluentImpl<CloudwatchBuilder> implements VisitableBuilder<Cloudwatch,CloudwatchBuilder>{

    CloudwatchFluent<?> fluent;
    Boolean validationEnabled;

    public CloudwatchBuilder(){
            this(true);
    }
    public CloudwatchBuilder(Boolean validationEnabled){
            this(new Cloudwatch(), validationEnabled);
    }
    public CloudwatchBuilder(CloudwatchFluent<?> fluent){
            this(fluent, true);
    }
    public CloudwatchBuilder(CloudwatchFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Cloudwatch(), validationEnabled);
    }
    public CloudwatchBuilder(CloudwatchFluent<?> fluent,Cloudwatch instance){
            this(fluent, instance, true);
    }
    public CloudwatchBuilder(CloudwatchFluent<?> fluent,Cloudwatch instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLogGroupName(instance.getLogGroupName()); 
            fluent.withLogStreamName(instance.getLogStreamName()); 
            fluent.withLogs(instance.getLogs()); 
            fluent.withMetricInfo(instance.getMetricInfo()); 
            fluent.withNamespace(instance.getNamespace()); 
            this.validationEnabled = validationEnabled; 
    }
    public CloudwatchBuilder(Cloudwatch instance){
            this(instance,true);
    }
    public CloudwatchBuilder(Cloudwatch instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLogGroupName(instance.getLogGroupName()); 
            this.withLogStreamName(instance.getLogStreamName()); 
            this.withLogs(instance.getLogs()); 
            this.withMetricInfo(instance.getMetricInfo()); 
            this.withNamespace(instance.getNamespace()); 
            this.validationEnabled = validationEnabled; 
    }

    public Cloudwatch build(){
            Cloudwatch buildable = new Cloudwatch(fluent.getLogGroupName(),fluent.getLogStreamName(),fluent.getLogs(),fluent.getMetricInfo(),fluent.getNamespace());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CloudwatchBuilder that = (CloudwatchBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
