package me.snowdrop.istio.mixer.adapter.cloudwatch;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public interface CloudwatchFluent<A extends CloudwatchFluent<A>> extends Fluent<A>{


    public String getLogGroupName();
    public A withLogGroupName(String logGroupName);
    public Boolean hasLogGroupName();
    public A withNewLogGroupName(String arg1);
    public A withNewLogGroupName(StringBuilder arg1);
    public A withNewLogGroupName(StringBuffer arg1);
    public String getLogStreamName();
    public A withLogStreamName(String logStreamName);
    public Boolean hasLogStreamName();
    public A withNewLogStreamName(String arg1);
    public A withNewLogStreamName(StringBuilder arg1);
    public A withNewLogStreamName(StringBuffer arg1);
    public A addToLogs(String key,LogInfo value);
    public A addToLogs(Map<String,LogInfo> map);
    public A removeFromLogs(String key);
    public A removeFromLogs(Map<String,LogInfo> map);
    public Map<String,LogInfo> getLogs();
    public A withLogs(Map<String,LogInfo> logs);
    public Boolean hasLogs();
    public A addToMetricInfo(String key,MetricDatum value);
    public A addToMetricInfo(Map<String,MetricDatum> map);
    public A removeFromMetricInfo(String key);
    public A removeFromMetricInfo(Map<String,MetricDatum> map);
    public Map<String,MetricDatum> getMetricInfo();
    public A withMetricInfo(Map<String,MetricDatum> metricInfo);
    public Boolean hasMetricInfo();
    public String getNamespace();
    public A withNamespace(String namespace);
    public Boolean hasNamespace();
    public A withNewNamespace(String arg1);
    public A withNewNamespace(StringBuilder arg1);
    public A withNewNamespace(StringBuffer arg1);



}
