package me.snowdrop.istio.mixer.adapter.cloudwatch;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MetricDatumBuilder extends MetricDatumFluentImpl<MetricDatumBuilder> implements VisitableBuilder<MetricDatum,MetricDatumBuilder>{

    MetricDatumFluent<?> fluent;
    Boolean validationEnabled;

    public MetricDatumBuilder(){
            this(true);
    }
    public MetricDatumBuilder(Boolean validationEnabled){
            this(new MetricDatum(), validationEnabled);
    }
    public MetricDatumBuilder(MetricDatumFluent<?> fluent){
            this(fluent, true);
    }
    public MetricDatumBuilder(MetricDatumFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MetricDatum(), validationEnabled);
    }
    public MetricDatumBuilder(MetricDatumFluent<?> fluent,MetricDatum instance){
            this(fluent, instance, true);
    }
    public MetricDatumBuilder(MetricDatumFluent<?> fluent,MetricDatum instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withUnit(instance.getUnit()); 
            this.validationEnabled = validationEnabled; 
    }
    public MetricDatumBuilder(MetricDatum instance){
            this(instance,true);
    }
    public MetricDatumBuilder(MetricDatum instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withUnit(instance.getUnit()); 
            this.validationEnabled = validationEnabled; 
    }

    public MetricDatum build(){
            MetricDatum buildable = new MetricDatum(fluent.getUnit());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MetricDatumBuilder that = (MetricDatumBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
