
package me.snowdrop.istio.mixer.adapter.denier;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Status;
import me.snowdrop.istio.api.internal.MixerAdapter;
import me.snowdrop.istio.api.policy.v1beta1.HandlerParams;


/**
 * 
 */
@MixerAdapter(compiledAdapter = "denier")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "status",
    "validDuration",
    "validUseCount"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Denier implements Serializable, HandlerParams
{

    /**
     * 
     */
    @JsonProperty("status")
    @JsonPropertyDescription("")
    private Status status;
    /**
     * 
     */
    @JsonProperty("validDuration")
    @JsonPropertyDescription("")
    private Integer validDuration;
    /**
     * 
     */
    @JsonProperty("validUseCount")
    @JsonPropertyDescription("")
    private Integer validUseCount;
    private final static long serialVersionUID = -5760109939645854888L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Denier() {
    }

    /**
     * 
     * @param validDuration
     * @param validUseCount
     * @param status
     */
    public Denier(Status status, Integer validDuration, Integer validUseCount) {
        super();
        this.status = status;
        this.validDuration = validDuration;
        this.validUseCount = validUseCount;
    }

    /**
     * 
     */
    public Status getStatus() {
        return status;
    }

    /**
     * 
     */
    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * 
     */
    public Integer getValidDuration() {
        return validDuration;
    }

    /**
     * 
     */
    public void setValidDuration(Integer validDuration) {
        this.validDuration = validDuration;
    }

    /**
     * 
     */
    public Integer getValidUseCount() {
        return validUseCount;
    }

    /**
     * 
     */
    public void setValidUseCount(Integer validUseCount) {
        this.validUseCount = validUseCount;
    }

}
