package me.snowdrop.istio.mixer.adapter.denier;

import me.snowdrop.istio.api.Status;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;
import java.lang.Deprecated;
import me.snowdrop.istio.api.StatusFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import me.snowdrop.istio.api.StatusBuilder;
import java.lang.Boolean;

public class DenierFluentImpl<A extends DenierFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DenierFluent<A>{

    private StatusBuilder status;
    private Integer validDuration;
    private Integer validUseCount;

    public DenierFluentImpl(){
    }
    public DenierFluentImpl(Denier instance){
            this.withStatus(instance.getStatus()); 
            this.withValidDuration(instance.getValidDuration()); 
            this.withValidUseCount(instance.getValidUseCount()); 
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public Status getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public Status buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(Status status){
            _visitables.get("status").remove(this.status);
            if (status!=null){ this.status= new StatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public DenierFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public DenierFluent.StatusNested<A> withNewStatusLike(Status item){
            return new StatusNestedImpl(item);
    }

    public DenierFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public DenierFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new StatusBuilder().build());
    }

    public DenierFluent.StatusNested<A> editOrNewStatusLike(Status item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public Integer getValidDuration(){
            return this.validDuration;
    }

    public A withValidDuration(Integer validDuration){
            this.validDuration=validDuration; return (A) this;
    }

    public Boolean hasValidDuration(){
            return this.validDuration != null;
    }

    public Integer getValidUseCount(){
            return this.validUseCount;
    }

    public A withValidUseCount(Integer validUseCount){
            this.validUseCount=validUseCount; return (A) this;
    }

    public Boolean hasValidUseCount(){
            return this.validUseCount != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            DenierFluentImpl that = (DenierFluentImpl) o;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            if (validDuration != null ? !validDuration.equals(that.validDuration) :that.validDuration != null) return false;
            if (validUseCount != null ? !validUseCount.equals(that.validUseCount) :that.validUseCount != null) return false;
            return true;
    }


    public class StatusNestedImpl<N> extends StatusFluentImpl<DenierFluent.StatusNested<N>> implements DenierFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final StatusBuilder builder;
    
            StatusNestedImpl(Status item){
                    this.builder = new StatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new StatusBuilder(this);
            }
    
    public N and(){
            return (N) DenierFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
