
package me.snowdrop.istio.mixer.adapter.dogstatsd;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.internal.MixerAdapter;
import me.snowdrop.istio.api.policy.v1beta1.HandlerParams;


/**
 * 
 */
@MixerAdapter(compiledAdapter = "dogstatsd")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "address",
    "bufferLength",
    "globalTags",
    "metrics",
    "prefix",
    "sampleRate"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Dogstatsd implements Serializable, HandlerParams
{

    /**
     * 
     */
    @JsonProperty("address")
    @JsonPropertyDescription("")
    private java.lang.String address;
    /**
     * 
     */
    @JsonProperty("bufferLength")
    @JsonPropertyDescription("")
    private Integer bufferLength;
    /**
     * 
     */
    @JsonProperty("globalTags")
    @JsonPropertyDescription("")
    private Map<String, String> globalTags;
    /**
     * 
     */
    @JsonProperty("metrics")
    @JsonPropertyDescription("")
    private Map<String, MetricInfo> metrics;
    /**
     * 
     */
    @JsonProperty("prefix")
    @JsonPropertyDescription("")
    private java.lang.String prefix;
    /**
     * 
     */
    @JsonProperty("sampleRate")
    @JsonPropertyDescription("")
    private Double sampleRate;
    private final static long serialVersionUID = 7936578664177847803L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Dogstatsd() {
    }

    /**
     * 
     * @param address
     * @param prefix
     * @param bufferLength
     * @param metrics
     * @param globalTags
     * @param sampleRate
     */
    public Dogstatsd(java.lang.String address, Integer bufferLength, Map<String, String> globalTags, Map<String, MetricInfo> metrics, java.lang.String prefix, Double sampleRate) {
        super();
        this.address = address;
        this.bufferLength = bufferLength;
        this.globalTags = globalTags;
        this.metrics = metrics;
        this.prefix = prefix;
        this.sampleRate = sampleRate;
    }

    /**
     * 
     */
    public java.lang.String getAddress() {
        return address;
    }

    /**
     * 
     */
    public void setAddress(java.lang.String address) {
        this.address = address;
    }

    /**
     * 
     */
    public Integer getBufferLength() {
        return bufferLength;
    }

    /**
     * 
     */
    public void setBufferLength(Integer bufferLength) {
        this.bufferLength = bufferLength;
    }

    /**
     * 
     */
    public Map<String, String> getGlobalTags() {
        return globalTags;
    }

    /**
     * 
     */
    public void setGlobalTags(Map<String, String> globalTags) {
        this.globalTags = globalTags;
    }

    /**
     * 
     */
    public Map<String, MetricInfo> getMetrics() {
        return metrics;
    }

    /**
     * 
     */
    public void setMetrics(Map<String, MetricInfo> metrics) {
        this.metrics = metrics;
    }

    /**
     * 
     */
    public java.lang.String getPrefix() {
        return prefix;
    }

    /**
     * 
     */
    public void setPrefix(java.lang.String prefix) {
        this.prefix = prefix;
    }

    /**
     * 
     */
    public Double getSampleRate() {
        return sampleRate;
    }

    /**
     * 
     */
    public void setSampleRate(Double sampleRate) {
        this.sampleRate = sampleRate;
    }

}
