package me.snowdrop.istio.mixer.adapter.dogstatsd;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DogstatsdBuilder extends DogstatsdFluentImpl<DogstatsdBuilder> implements VisitableBuilder<Dogstatsd,DogstatsdBuilder>{

    DogstatsdFluent<?> fluent;
    Boolean validationEnabled;

    public DogstatsdBuilder(){
            this(true);
    }
    public DogstatsdBuilder(Boolean validationEnabled){
            this(new Dogstatsd(), validationEnabled);
    }
    public DogstatsdBuilder(DogstatsdFluent<?> fluent){
            this(fluent, true);
    }
    public DogstatsdBuilder(DogstatsdFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Dogstatsd(), validationEnabled);
    }
    public DogstatsdBuilder(DogstatsdFluent<?> fluent,Dogstatsd instance){
            this(fluent, instance, true);
    }
    public DogstatsdBuilder(DogstatsdFluent<?> fluent,Dogstatsd instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withBufferLength(instance.getBufferLength()); 
            fluent.withGlobalTags(instance.getGlobalTags()); 
            fluent.withMetrics(instance.getMetrics()); 
            fluent.withPrefix(instance.getPrefix()); 
            fluent.withSampleRate(instance.getSampleRate()); 
            this.validationEnabled = validationEnabled; 
    }
    public DogstatsdBuilder(Dogstatsd instance){
            this(instance,true);
    }
    public DogstatsdBuilder(Dogstatsd instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withBufferLength(instance.getBufferLength()); 
            this.withGlobalTags(instance.getGlobalTags()); 
            this.withMetrics(instance.getMetrics()); 
            this.withPrefix(instance.getPrefix()); 
            this.withSampleRate(instance.getSampleRate()); 
            this.validationEnabled = validationEnabled; 
    }

    public Dogstatsd build(){
            Dogstatsd buildable = new Dogstatsd(fluent.getAddress(),fluent.getBufferLength(),fluent.getGlobalTags(),fluent.getMetrics(),fluent.getPrefix(),fluent.getSampleRate());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DogstatsdBuilder that = (DogstatsdBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
