package me.snowdrop.istio.mixer.adapter.dogstatsd;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.lang.String;
import java.lang.Double;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class DogstatsdFluentImpl<A extends DogstatsdFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DogstatsdFluent<A>{

    private String address;
    private Integer bufferLength;
    private Map<String,String> globalTags;
    private Map<String,me.snowdrop.istio.mixer.adapter.dogstatsd.MetricInfo> metrics;
    private String prefix;
    private Double sampleRate;

    public DogstatsdFluentImpl(){
    }
    public DogstatsdFluentImpl(Dogstatsd instance){
            this.withAddress(instance.getAddress()); 
            this.withBufferLength(instance.getBufferLength()); 
            this.withGlobalTags(instance.getGlobalTags()); 
            this.withMetrics(instance.getMetrics()); 
            this.withPrefix(instance.getPrefix()); 
            this.withSampleRate(instance.getSampleRate()); 
    }

    public String getAddress(){
            return this.address;
    }

    public A withAddress(String address){
            this.address=address; return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public A withNewAddress(String arg1){
            return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuilder arg1){
            return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuffer arg1){
            return (A)withAddress(new String(arg1));
    }

    public Integer getBufferLength(){
            return this.bufferLength;
    }

    public A withBufferLength(Integer bufferLength){
            this.bufferLength=bufferLength; return (A) this;
    }

    public Boolean hasBufferLength(){
            return this.bufferLength != null;
    }

    public A addToGlobalTags(String key,String value){
            if(this.globalTags == null && key != null && value != null) { this.globalTags = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.globalTags.put(key, value);} return (A)this;
    }

    public A addToGlobalTags(Map<String,String> map){
            if(this.globalTags == null && map != null) { this.globalTags = new LinkedHashMap<String,String>(); }
            if(map != null) { this.globalTags.putAll(map);} return (A)this;
    }

    public A removeFromGlobalTags(String key){
            if(this.globalTags == null) { return (A) this; }
            if(key != null && this.globalTags != null) {this.globalTags.remove(key);} return (A)this;
    }

    public A removeFromGlobalTags(Map<String,String> map){
            if(this.globalTags == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.globalTags != null){this.globalTags.remove(key);}}} return (A)this;
    }

    public Map<String,String> getGlobalTags(){
            return this.globalTags;
    }

    public A withGlobalTags(Map<String,String> globalTags){
            if (globalTags == null) { this.globalTags =  null;} else {this.globalTags = new LinkedHashMap<String,String>(globalTags);} return (A) this;
    }

    public Boolean hasGlobalTags(){
            return this.globalTags != null;
    }

    public A addToMetrics(String key,me.snowdrop.istio.mixer.adapter.dogstatsd.MetricInfo value){
            if(this.metrics == null && key != null && value != null) { this.metrics = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.dogstatsd.MetricInfo>(); }
            if(key != null && value != null) {this.metrics.put(key, value);} return (A)this;
    }

    public A addToMetrics(Map<String,me.snowdrop.istio.mixer.adapter.dogstatsd.MetricInfo> map){
            if(this.metrics == null && map != null) { this.metrics = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.dogstatsd.MetricInfo>(); }
            if(map != null) { this.metrics.putAll(map);} return (A)this;
    }

    public A removeFromMetrics(String key){
            if(this.metrics == null) { return (A) this; }
            if(key != null && this.metrics != null) {this.metrics.remove(key);} return (A)this;
    }

    public A removeFromMetrics(Map<String,me.snowdrop.istio.mixer.adapter.dogstatsd.MetricInfo> map){
            if(this.metrics == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.metrics != null){this.metrics.remove(key);}}} return (A)this;
    }

    public Map<String,me.snowdrop.istio.mixer.adapter.dogstatsd.MetricInfo> getMetrics(){
            return this.metrics;
    }

    public A withMetrics(Map<String,me.snowdrop.istio.mixer.adapter.dogstatsd.MetricInfo> metrics){
            if (metrics == null) { this.metrics =  null;} else {this.metrics = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.dogstatsd.MetricInfo>(metrics);} return (A) this;
    }

    public Boolean hasMetrics(){
            return this.metrics != null;
    }

    public String getPrefix(){
            return this.prefix;
    }

    public A withPrefix(String prefix){
            this.prefix=prefix; return (A) this;
    }

    public Boolean hasPrefix(){
            return this.prefix != null;
    }

    public A withNewPrefix(String arg1){
            return (A)withPrefix(new String(arg1));
    }

    public A withNewPrefix(StringBuilder arg1){
            return (A)withPrefix(new String(arg1));
    }

    public A withNewPrefix(StringBuffer arg1){
            return (A)withPrefix(new String(arg1));
    }

    public Double getSampleRate(){
            return this.sampleRate;
    }

    public A withSampleRate(Double sampleRate){
            this.sampleRate=sampleRate; return (A) this;
    }

    public Boolean hasSampleRate(){
            return this.sampleRate != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            DogstatsdFluentImpl that = (DogstatsdFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (bufferLength != null ? !bufferLength.equals(that.bufferLength) :that.bufferLength != null) return false;
            if (globalTags != null ? !globalTags.equals(that.globalTags) :that.globalTags != null) return false;
            if (metrics != null ? !metrics.equals(that.metrics) :that.metrics != null) return false;
            if (prefix != null ? !prefix.equals(that.prefix) :that.prefix != null) return false;
            if (sampleRate != null ? !sampleRate.equals(that.sampleRate) :that.sampleRate != null) return false;
            return true;
    }




}
