package me.snowdrop.istio.mixer.adapter.dogstatsd;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class MetricInfoFluentImpl<A extends me.snowdrop.istio.mixer.adapter.dogstatsd.MetricInfoFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.mixer.adapter.dogstatsd.MetricInfoFluent<A>{

    private String name;
    private Map<String,String> tags;
    private me.snowdrop.istio.mixer.adapter.dogstatsd.Type type;

    public MetricInfoFluentImpl(){
    }
    public MetricInfoFluentImpl(me.snowdrop.istio.mixer.adapter.dogstatsd.MetricInfo instance){
            this.withName(instance.getName()); 
            this.withTags(instance.getTags()); 
            this.withType(instance.getType()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public A addToTags(String key,String value){
            if(this.tags == null && key != null && value != null) { this.tags = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.tags.put(key, value);} return (A)this;
    }

    public A addToTags(Map<String,String> map){
            if(this.tags == null && map != null) { this.tags = new LinkedHashMap<String,String>(); }
            if(map != null) { this.tags.putAll(map);} return (A)this;
    }

    public A removeFromTags(String key){
            if(this.tags == null) { return (A) this; }
            if(key != null && this.tags != null) {this.tags.remove(key);} return (A)this;
    }

    public A removeFromTags(Map<String,String> map){
            if(this.tags == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.tags != null){this.tags.remove(key);}}} return (A)this;
    }

    public Map<String,String> getTags(){
            return this.tags;
    }

    public A withTags(Map<String,String> tags){
            if (tags == null) { this.tags =  null;} else {this.tags = new LinkedHashMap<String,String>(tags);} return (A) this;
    }

    public Boolean hasTags(){
            return this.tags != null;
    }

    public me.snowdrop.istio.mixer.adapter.dogstatsd.Type getType(){
            return this.type;
    }

    public A withType(me.snowdrop.istio.mixer.adapter.dogstatsd.Type type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            MetricInfoFluentImpl that = (MetricInfoFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (tags != null ? !tags.equals(that.tags) :that.tags != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }




}
