
package me.snowdrop.istio.mixer.adapter.fluentd;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.internal.MixerAdapter;
import me.snowdrop.istio.api.policy.v1beta1.HandlerParams;


/**
 * 
 */
@MixerAdapter(compiledAdapter = "fluentd")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "address",
    "instanceBufferSize",
    "integerDuration",
    "maxBatchSizeBytes",
    "pushIntervalDuration",
    "pushTimeoutDuration"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Fluentd implements Serializable, HandlerParams
{

    /**
     * 
     */
    @JsonProperty("address")
    @JsonPropertyDescription("")
    private String address;
    /**
     * 
     */
    @JsonProperty("instanceBufferSize")
    @JsonPropertyDescription("")
    private Integer instanceBufferSize;
    /**
     * 
     */
    @JsonProperty("integerDuration")
    @JsonPropertyDescription("")
    private Boolean integerDuration;
    /**
     * 
     */
    @JsonProperty("maxBatchSizeBytes")
    @JsonPropertyDescription("")
    private Integer maxBatchSizeBytes;
    /**
     * 
     */
    @JsonProperty("pushIntervalDuration")
    @JsonPropertyDescription("")
    private Integer pushIntervalDuration;
    /**
     * 
     */
    @JsonProperty("pushTimeoutDuration")
    @JsonPropertyDescription("")
    private Integer pushTimeoutDuration;
    private final static long serialVersionUID = 3511031877410236086L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Fluentd() {
    }

    /**
     * 
     * @param pushTimeoutDuration
     * @param address
     * @param integerDuration
     * @param maxBatchSizeBytes
     * @param instanceBufferSize
     * @param pushIntervalDuration
     */
    public Fluentd(String address, Integer instanceBufferSize, Boolean integerDuration, Integer maxBatchSizeBytes, Integer pushIntervalDuration, Integer pushTimeoutDuration) {
        super();
        this.address = address;
        this.instanceBufferSize = instanceBufferSize;
        this.integerDuration = integerDuration;
        this.maxBatchSizeBytes = maxBatchSizeBytes;
        this.pushIntervalDuration = pushIntervalDuration;
        this.pushTimeoutDuration = pushTimeoutDuration;
    }

    /**
     * 
     */
    public String getAddress() {
        return address;
    }

    /**
     * 
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * 
     */
    public Integer getInstanceBufferSize() {
        return instanceBufferSize;
    }

    /**
     * 
     */
    public void setInstanceBufferSize(Integer instanceBufferSize) {
        this.instanceBufferSize = instanceBufferSize;
    }

    /**
     * 
     */
    public Boolean getIntegerDuration() {
        return integerDuration;
    }

    /**
     * 
     */
    public void setIntegerDuration(Boolean integerDuration) {
        this.integerDuration = integerDuration;
    }

    /**
     * 
     */
    public Integer getMaxBatchSizeBytes() {
        return maxBatchSizeBytes;
    }

    /**
     * 
     */
    public void setMaxBatchSizeBytes(Integer maxBatchSizeBytes) {
        this.maxBatchSizeBytes = maxBatchSizeBytes;
    }

    /**
     * 
     */
    public Integer getPushIntervalDuration() {
        return pushIntervalDuration;
    }

    /**
     * 
     */
    public void setPushIntervalDuration(Integer pushIntervalDuration) {
        this.pushIntervalDuration = pushIntervalDuration;
    }

    /**
     * 
     */
    public Integer getPushTimeoutDuration() {
        return pushTimeoutDuration;
    }

    /**
     * 
     */
    public void setPushTimeoutDuration(Integer pushTimeoutDuration) {
        this.pushTimeoutDuration = pushTimeoutDuration;
    }

}
