package me.snowdrop.istio.mixer.adapter.fluentd;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FluentdBuilder extends FluentdFluentImpl<FluentdBuilder> implements VisitableBuilder<Fluentd,FluentdBuilder>{

    FluentdFluent<?> fluent;
    Boolean validationEnabled;

    public FluentdBuilder(){
            this(true);
    }
    public FluentdBuilder(Boolean validationEnabled){
            this(new Fluentd(), validationEnabled);
    }
    public FluentdBuilder(FluentdFluent<?> fluent){
            this(fluent, true);
    }
    public FluentdBuilder(FluentdFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Fluentd(), validationEnabled);
    }
    public FluentdBuilder(FluentdFluent<?> fluent,Fluentd instance){
            this(fluent, instance, true);
    }
    public FluentdBuilder(FluentdFluent<?> fluent,Fluentd instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withInstanceBufferSize(instance.getInstanceBufferSize()); 
            fluent.withIntegerDuration(instance.getIntegerDuration()); 
            fluent.withMaxBatchSizeBytes(instance.getMaxBatchSizeBytes()); 
            fluent.withPushIntervalDuration(instance.getPushIntervalDuration()); 
            fluent.withPushTimeoutDuration(instance.getPushTimeoutDuration()); 
            this.validationEnabled = validationEnabled; 
    }
    public FluentdBuilder(Fluentd instance){
            this(instance,true);
    }
    public FluentdBuilder(Fluentd instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withInstanceBufferSize(instance.getInstanceBufferSize()); 
            this.withIntegerDuration(instance.getIntegerDuration()); 
            this.withMaxBatchSizeBytes(instance.getMaxBatchSizeBytes()); 
            this.withPushIntervalDuration(instance.getPushIntervalDuration()); 
            this.withPushTimeoutDuration(instance.getPushTimeoutDuration()); 
            this.validationEnabled = validationEnabled; 
    }

    public Fluentd build(){
            Fluentd buildable = new Fluentd(fluent.getAddress(),fluent.getInstanceBufferSize(),fluent.isIntegerDuration(),fluent.getMaxBatchSizeBytes(),fluent.getPushIntervalDuration(),fluent.getPushTimeoutDuration());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            FluentdBuilder that = (FluentdBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
