
package me.snowdrop.istio.mixer.adapter.kubernetesenv;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.internal.MixerAdapter;
import me.snowdrop.istio.api.policy.v1beta1.HandlerParams;


/**
 * 
 */
@MixerAdapter(compiledAdapter = "kubernetesenv")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "cacheRefreshDuration",
    "clusterRegistriesNamespace",
    "kubeconfigPath"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Kubernetesenv implements Serializable, HandlerParams
{

    /**
     * 
     */
    @JsonProperty("cacheRefreshDuration")
    @JsonPropertyDescription("")
    private Integer cacheRefreshDuration;
    /**
     * 
     */
    @JsonProperty("clusterRegistriesNamespace")
    @JsonPropertyDescription("")
    private String clusterRegistriesNamespace;
    /**
     * 
     */
    @JsonProperty("kubeconfigPath")
    @JsonPropertyDescription("")
    private String kubeconfigPath;
    private final static long serialVersionUID = 4330363769655384449L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Kubernetesenv() {
    }

    /**
     * 
     * @param cacheRefreshDuration
     * @param clusterRegistriesNamespace
     * @param kubeconfigPath
     */
    public Kubernetesenv(Integer cacheRefreshDuration, String clusterRegistriesNamespace, String kubeconfigPath) {
        super();
        this.cacheRefreshDuration = cacheRefreshDuration;
        this.clusterRegistriesNamespace = clusterRegistriesNamespace;
        this.kubeconfigPath = kubeconfigPath;
    }

    /**
     * 
     */
    public Integer getCacheRefreshDuration() {
        return cacheRefreshDuration;
    }

    /**
     * 
     */
    public void setCacheRefreshDuration(Integer cacheRefreshDuration) {
        this.cacheRefreshDuration = cacheRefreshDuration;
    }

    /**
     * 
     */
    public String getClusterRegistriesNamespace() {
        return clusterRegistriesNamespace;
    }

    /**
     * 
     */
    public void setClusterRegistriesNamespace(String clusterRegistriesNamespace) {
        this.clusterRegistriesNamespace = clusterRegistriesNamespace;
    }

    /**
     * 
     */
    public String getKubeconfigPath() {
        return kubeconfigPath;
    }

    /**
     * 
     */
    public void setKubeconfigPath(String kubeconfigPath) {
        this.kubeconfigPath = kubeconfigPath;
    }

}
