package me.snowdrop.istio.mixer.adapter.kubernetesenv;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class KubernetesenvFluentImpl<A extends KubernetesenvFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KubernetesenvFluent<A>{

    private Integer cacheRefreshDuration;
    private String clusterRegistriesNamespace;
    private String kubeconfigPath;

    public KubernetesenvFluentImpl(){
    }
    public KubernetesenvFluentImpl(Kubernetesenv instance){
            this.withCacheRefreshDuration(instance.getCacheRefreshDuration()); 
            this.withClusterRegistriesNamespace(instance.getClusterRegistriesNamespace()); 
            this.withKubeconfigPath(instance.getKubeconfigPath()); 
    }

    public Integer getCacheRefreshDuration(){
            return this.cacheRefreshDuration;
    }

    public A withCacheRefreshDuration(Integer cacheRefreshDuration){
            this.cacheRefreshDuration=cacheRefreshDuration; return (A) this;
    }

    public Boolean hasCacheRefreshDuration(){
            return this.cacheRefreshDuration != null;
    }

    public String getClusterRegistriesNamespace(){
            return this.clusterRegistriesNamespace;
    }

    public A withClusterRegistriesNamespace(String clusterRegistriesNamespace){
            this.clusterRegistriesNamespace=clusterRegistriesNamespace; return (A) this;
    }

    public Boolean hasClusterRegistriesNamespace(){
            return this.clusterRegistriesNamespace != null;
    }

    public A withNewClusterRegistriesNamespace(String arg1){
            return (A)withClusterRegistriesNamespace(new String(arg1));
    }

    public A withNewClusterRegistriesNamespace(StringBuilder arg1){
            return (A)withClusterRegistriesNamespace(new String(arg1));
    }

    public A withNewClusterRegistriesNamespace(StringBuffer arg1){
            return (A)withClusterRegistriesNamespace(new String(arg1));
    }

    public String getKubeconfigPath(){
            return this.kubeconfigPath;
    }

    public A withKubeconfigPath(String kubeconfigPath){
            this.kubeconfigPath=kubeconfigPath; return (A) this;
    }

    public Boolean hasKubeconfigPath(){
            return this.kubeconfigPath != null;
    }

    public A withNewKubeconfigPath(String arg1){
            return (A)withKubeconfigPath(new String(arg1));
    }

    public A withNewKubeconfigPath(StringBuilder arg1){
            return (A)withKubeconfigPath(new String(arg1));
    }

    public A withNewKubeconfigPath(StringBuffer arg1){
            return (A)withKubeconfigPath(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KubernetesenvFluentImpl that = (KubernetesenvFluentImpl) o;
            if (cacheRefreshDuration != null ? !cacheRefreshDuration.equals(that.cacheRefreshDuration) :that.cacheRefreshDuration != null) return false;
            if (clusterRegistriesNamespace != null ? !clusterRegistriesNamespace.equals(that.clusterRegistriesNamespace) :that.clusterRegistriesNamespace != null) return false;
            if (kubeconfigPath != null ? !kubeconfigPath.equals(that.kubeconfigPath) :that.kubeconfigPath != null) return false;
            return true;
    }




}
