
package me.snowdrop.istio.mixer.adapter.list;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.internal.MixerAdapter;
import me.snowdrop.istio.api.policy.v1beta1.HandlerParams;


/**
 * 
 */
@MixerAdapter(compiledAdapter = "list")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "blacklist",
    "cachingInterval",
    "cachingUseCount",
    "entryType",
    "overrides",
    "providerUrl",
    "refreshInterval",
    "ttl"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class BaseKubernetesList implements Serializable, HandlerParams
{

    /**
     * 
     */
    @JsonProperty("blacklist")
    @JsonPropertyDescription("")
    private Boolean blacklist;
    /**
     * 
     */
    @JsonProperty("cachingInterval")
    @JsonPropertyDescription("")
    private Integer cachingInterval;
    /**
     * 
     */
    @JsonProperty("cachingUseCount")
    @JsonPropertyDescription("")
    private Integer cachingUseCount;
    @JsonProperty("entryType")
    private ListEntryType entryType;
    /**
     * 
     */
    @JsonProperty("overrides")
    @JsonPropertyDescription("")
    private List<String> overrides = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("providerUrl")
    @JsonPropertyDescription("")
    private String providerUrl;
    /**
     * 
     */
    @JsonProperty("refreshInterval")
    @JsonPropertyDescription("")
    private Integer refreshInterval;
    /**
     * 
     */
    @JsonProperty("ttl")
    @JsonPropertyDescription("")
    private Integer ttl;
    private final static long serialVersionUID = 8895689859297377603L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public BaseKubernetesList() {
    }

    /**
     * 
     * @param entryType
     * @param refreshInterval
     * @param blacklist
     * @param cachingUseCount
     * @param overrides
     * @param cachingInterval
     * @param ttl
     * @param providerUrl
     */
    public BaseKubernetesList(Boolean blacklist, Integer cachingInterval, Integer cachingUseCount, ListEntryType entryType, List<String> overrides, String providerUrl, Integer refreshInterval, Integer ttl) {
        super();
        this.blacklist = blacklist;
        this.cachingInterval = cachingInterval;
        this.cachingUseCount = cachingUseCount;
        this.entryType = entryType;
        this.overrides = overrides;
        this.providerUrl = providerUrl;
        this.refreshInterval = refreshInterval;
        this.ttl = ttl;
    }

    /**
     * 
     */
    public Boolean getBlacklist() {
        return blacklist;
    }

    /**
     * 
     */
    public void setBlacklist(Boolean blacklist) {
        this.blacklist = blacklist;
    }

    /**
     * 
     */
    public Integer getCachingInterval() {
        return cachingInterval;
    }

    /**
     * 
     */
    public void setCachingInterval(Integer cachingInterval) {
        this.cachingInterval = cachingInterval;
    }

    /**
     * 
     */
    public Integer getCachingUseCount() {
        return cachingUseCount;
    }

    /**
     * 
     */
    public void setCachingUseCount(Integer cachingUseCount) {
        this.cachingUseCount = cachingUseCount;
    }

    public ListEntryType getEntryType() {
        return entryType;
    }

    public void setEntryType(ListEntryType entryType) {
        this.entryType = entryType;
    }

    /**
     * 
     */
    public List<String> getOverrides() {
        return overrides;
    }

    /**
     * 
     */
    public void setOverrides(List<String> overrides) {
        this.overrides = overrides;
    }

    /**
     * 
     */
    public String getProviderUrl() {
        return providerUrl;
    }

    /**
     * 
     */
    public void setProviderUrl(String providerUrl) {
        this.providerUrl = providerUrl;
    }

    /**
     * 
     */
    public Integer getRefreshInterval() {
        return refreshInterval;
    }

    /**
     * 
     */
    public void setRefreshInterval(Integer refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    /**
     * 
     */
    public Integer getTtl() {
        return ttl;
    }

    /**
     * 
     */
    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

}
