package me.snowdrop.istio.mixer.adapter.list;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BaseKubernetesListBuilder extends BaseKubernetesListFluentImpl<BaseKubernetesListBuilder> implements VisitableBuilder<BaseKubernetesList,BaseKubernetesListBuilder>{

    BaseKubernetesListFluent<?> fluent;
    Boolean validationEnabled;

    public BaseKubernetesListBuilder(){
            this(true);
    }
    public BaseKubernetesListBuilder(Boolean validationEnabled){
            this(new BaseKubernetesList(), validationEnabled);
    }
    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent){
            this(fluent, true);
    }
    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new BaseKubernetesList(), validationEnabled);
    }
    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent,BaseKubernetesList instance){
            this(fluent, instance, true);
    }
    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent,BaseKubernetesList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBlacklist(instance.getBlacklist()); 
            fluent.withCachingInterval(instance.getCachingInterval()); 
            fluent.withCachingUseCount(instance.getCachingUseCount()); 
            fluent.withEntryType(instance.getEntryType()); 
            fluent.withOverrides(instance.getOverrides()); 
            fluent.withProviderUrl(instance.getProviderUrl()); 
            fluent.withRefreshInterval(instance.getRefreshInterval()); 
            fluent.withTtl(instance.getTtl()); 
            this.validationEnabled = validationEnabled; 
    }
    public BaseKubernetesListBuilder(BaseKubernetesList instance){
            this(instance,true);
    }
    public BaseKubernetesListBuilder(BaseKubernetesList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBlacklist(instance.getBlacklist()); 
            this.withCachingInterval(instance.getCachingInterval()); 
            this.withCachingUseCount(instance.getCachingUseCount()); 
            this.withEntryType(instance.getEntryType()); 
            this.withOverrides(instance.getOverrides()); 
            this.withProviderUrl(instance.getProviderUrl()); 
            this.withRefreshInterval(instance.getRefreshInterval()); 
            this.withTtl(instance.getTtl()); 
            this.validationEnabled = validationEnabled; 
    }

    public BaseKubernetesList build(){
            BaseKubernetesList buildable = new BaseKubernetesList(fluent.isBlacklist(),fluent.getCachingInterval(),fluent.getCachingUseCount(),fluent.getEntryType(),fluent.getOverrides(),fluent.getProviderUrl(),fluent.getRefreshInterval(),fluent.getTtl());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BaseKubernetesListBuilder that = (BaseKubernetesListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
