package me.snowdrop.istio.mixer.adapter.list;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface BaseKubernetesListFluent<A extends BaseKubernetesListFluent<A>> extends Fluent<A>{


    public Boolean isBlacklist();
    public A withBlacklist(Boolean blacklist);
    public Boolean hasBlacklist();
    public A withNewBlacklist(String arg1);
    public A withNewBlacklist(boolean arg1);
    public Integer getCachingInterval();
    public A withCachingInterval(Integer cachingInterval);
    public Boolean hasCachingInterval();
    public Integer getCachingUseCount();
    public A withCachingUseCount(Integer cachingUseCount);
    public Boolean hasCachingUseCount();
    public ListEntryType getEntryType();
    public A withEntryType(ListEntryType entryType);
    public Boolean hasEntryType();
    public A addToOverrides(int index,String item);
    public A setToOverrides(int index,String item);
    public A addToOverrides(String... items);
    public A addAllToOverrides(Collection<String> items);
    public A removeFromOverrides(String... items);
    public A removeAllFromOverrides(Collection<String> items);
    public List<String> getOverrides();
    public String getOverride(int index);
    public String getFirstOverride();
    public String getLastOverride();
    public String getMatchingOverride(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingOverride(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withOverrides(List<String> overrides);
    public A withOverrides(String... overrides);
    public Boolean hasOverrides();
    public A addNewOverride(String arg1);
    public A addNewOverride(StringBuilder arg1);
    public A addNewOverride(StringBuffer arg1);
    public String getProviderUrl();
    public A withProviderUrl(String providerUrl);
    public Boolean hasProviderUrl();
    public A withNewProviderUrl(String arg1);
    public A withNewProviderUrl(StringBuilder arg1);
    public A withNewProviderUrl(StringBuffer arg1);
    public Integer getRefreshInterval();
    public A withRefreshInterval(Integer refreshInterval);
    public Boolean hasRefreshInterval();
    public Integer getTtl();
    public A withTtl(Integer ttl);
    public Boolean hasTtl();



}
