
package me.snowdrop.istio.mixer.adapter.memquota;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.internal.MixerAdapter;
import me.snowdrop.istio.api.policy.v1beta1.HandlerParams;


/**
 * 
 */
@MixerAdapter(compiledAdapter = "memquota")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "minDeduplicationDuration",
    "quotas"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Memquota implements Serializable, HandlerParams
{

    /**
     * 
     */
    @JsonProperty("minDeduplicationDuration")
    @JsonPropertyDescription("")
    private Integer minDeduplicationDuration;
    /**
     * 
     */
    @JsonProperty("quotas")
    @JsonPropertyDescription("")
    private List<Quota> quotas = new ArrayList<Quota>();
    private final static long serialVersionUID = -6863046160595919998L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Memquota() {
    }

    /**
     * 
     * @param quotas
     * @param minDeduplicationDuration
     */
    public Memquota(Integer minDeduplicationDuration, List<Quota> quotas) {
        super();
        this.minDeduplicationDuration = minDeduplicationDuration;
        this.quotas = quotas;
    }

    /**
     * 
     */
    public Integer getMinDeduplicationDuration() {
        return minDeduplicationDuration;
    }

    /**
     * 
     */
    public void setMinDeduplicationDuration(Integer minDeduplicationDuration) {
        this.minDeduplicationDuration = minDeduplicationDuration;
    }

    /**
     * 
     */
    public List<Quota> getQuotas() {
        return quotas;
    }

    /**
     * 
     */
    public void setQuotas(List<Quota> quotas) {
        this.quotas = quotas;
    }

}
