package me.snowdrop.istio.mixer.adapter.memquota;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MemquotaBuilder extends MemquotaFluentImpl<MemquotaBuilder> implements VisitableBuilder<Memquota,MemquotaBuilder>{

    MemquotaFluent<?> fluent;
    Boolean validationEnabled;

    public MemquotaBuilder(){
            this(true);
    }
    public MemquotaBuilder(Boolean validationEnabled){
            this(new Memquota(), validationEnabled);
    }
    public MemquotaBuilder(MemquotaFluent<?> fluent){
            this(fluent, true);
    }
    public MemquotaBuilder(MemquotaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Memquota(), validationEnabled);
    }
    public MemquotaBuilder(MemquotaFluent<?> fluent,Memquota instance){
            this(fluent, instance, true);
    }
    public MemquotaBuilder(MemquotaFluent<?> fluent,Memquota instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMinDeduplicationDuration(instance.getMinDeduplicationDuration()); 
            fluent.withQuotas(instance.getQuotas()); 
            this.validationEnabled = validationEnabled; 
    }
    public MemquotaBuilder(Memquota instance){
            this(instance,true);
    }
    public MemquotaBuilder(Memquota instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMinDeduplicationDuration(instance.getMinDeduplicationDuration()); 
            this.withQuotas(instance.getQuotas()); 
            this.validationEnabled = validationEnabled; 
    }

    public Memquota build(){
            Memquota buildable = new Memquota(fluent.getMinDeduplicationDuration(),fluent.getQuotas());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MemquotaBuilder that = (MemquotaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
