package me.snowdrop.istio.mixer.adapter.memquota;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class MemquotaFluentImpl<A extends MemquotaFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements MemquotaFluent<A>{

    private Integer minDeduplicationDuration;
    private List<QuotaBuilder> quotas;

    public MemquotaFluentImpl(){
    }
    public MemquotaFluentImpl(Memquota instance){
            this.withMinDeduplicationDuration(instance.getMinDeduplicationDuration()); 
            this.withQuotas(instance.getQuotas()); 
    }

    public Integer getMinDeduplicationDuration(){
            return this.minDeduplicationDuration;
    }

    public A withMinDeduplicationDuration(Integer minDeduplicationDuration){
            this.minDeduplicationDuration=minDeduplicationDuration; return (A) this;
    }

    public Boolean hasMinDeduplicationDuration(){
            return this.minDeduplicationDuration != null;
    }

    public A addToQuotas(int index,Quota item){
            if (this.quotas == null) {this.quotas = new ArrayList<QuotaBuilder>();}
            QuotaBuilder builder = new QuotaBuilder(item);_visitables.get("quotas").add(index >= 0 ? index : _visitables.get("quotas").size(), builder);this.quotas.add(index >= 0 ? index : quotas.size(), builder); return (A)this;
    }

    public A setToQuotas(int index,Quota item){
            if (this.quotas == null) {this.quotas = new ArrayList<QuotaBuilder>();}
            QuotaBuilder builder = new QuotaBuilder(item);
            if (index < 0 || index >= _visitables.get("quotas").size()) { _visitables.get("quotas").add(builder); } else { _visitables.get("quotas").set(index, builder);}
            if (index < 0 || index >= quotas.size()) { quotas.add(builder); } else { quotas.set(index, builder);}
             return (A)this;
    }

    public A addToQuotas(Quota... items){
            if (this.quotas == null) {this.quotas = new ArrayList<QuotaBuilder>();}
            for (Quota item : items) {QuotaBuilder builder = new QuotaBuilder(item);_visitables.get("quotas").add(builder);this.quotas.add(builder);} return (A)this;
    }

    public A addAllToQuotas(Collection<Quota> items){
            if (this.quotas == null) {this.quotas = new ArrayList<QuotaBuilder>();}
            for (Quota item : items) {QuotaBuilder builder = new QuotaBuilder(item);_visitables.get("quotas").add(builder);this.quotas.add(builder);} return (A)this;
    }

    public A removeFromQuotas(Quota... items){
            for (Quota item : items) {QuotaBuilder builder = new QuotaBuilder(item);_visitables.get("quotas").remove(builder);if (this.quotas != null) {this.quotas.remove(builder);}} return (A)this;
    }

    public A removeAllFromQuotas(Collection<Quota> items){
            for (Quota item : items) {QuotaBuilder builder = new QuotaBuilder(item);_visitables.get("quotas").remove(builder);if (this.quotas != null) {this.quotas.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromQuotas(io.fabric8.kubernetes.api.builder.Predicate<QuotaBuilder> predicate){
            if (quotas == null) return (A) this;
            final Iterator<QuotaBuilder> each = quotas.iterator();
            final List visitables = _visitables.get("quotas");
            while (each.hasNext()) {
              QuotaBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildQuotas instead.
 * @return The buildable object.
 */
@Deprecated public List<Quota> getQuotas(){
            return build(quotas);
    }

    public List<Quota> buildQuotas(){
            return build(quotas);
    }

    public Quota buildQuota(int index){
            return this.quotas.get(index).build();
    }

    public Quota buildFirstQuota(){
            return this.quotas.get(0).build();
    }

    public Quota buildLastQuota(){
            return this.quotas.get(quotas.size() - 1).build();
    }

    public Quota buildMatchingQuota(io.fabric8.kubernetes.api.builder.Predicate<QuotaBuilder> predicate){
            for (QuotaBuilder item: quotas) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingQuota(io.fabric8.kubernetes.api.builder.Predicate<QuotaBuilder> predicate){
            for (QuotaBuilder item: quotas) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withQuotas(List<Quota> quotas){
            if (this.quotas != null) { _visitables.get("quotas").removeAll(this.quotas);}
            if (quotas != null) {this.quotas = new ArrayList<QuotaBuilder>(); for (Quota item : quotas){this.addToQuotas(item);}} else { this.quotas = null;} return (A) this;
    }

    public A withQuotas(Quota... quotas){
            if (this.quotas != null) {this.quotas.clear();}
            if (quotas != null) {for (Quota item :quotas){ this.addToQuotas(item);}} return (A) this;
    }

    public Boolean hasQuotas(){
            return quotas != null && !quotas.isEmpty();
    }

    public MemquotaFluent.QuotasNested<A> addNewQuota(){
            return new QuotasNestedImpl();
    }

    public MemquotaFluent.QuotasNested<A> addNewQuotaLike(Quota item){
            return new QuotasNestedImpl(-1, item);
    }

    public MemquotaFluent.QuotasNested<A> setNewQuotaLike(int index,Quota item){
            return new QuotasNestedImpl(index, item);
    }

    public MemquotaFluent.QuotasNested<A> editQuota(int index){
            if (quotas.size() <= index) throw new RuntimeException("Can't edit quotas. Index exceeds size.");
            return setNewQuotaLike(index, buildQuota(index));
    }

    public MemquotaFluent.QuotasNested<A> editFirstQuota(){
            if (quotas.size() == 0) throw new RuntimeException("Can't edit first quotas. The list is empty.");
            return setNewQuotaLike(0, buildQuota(0));
    }

    public MemquotaFluent.QuotasNested<A> editLastQuota(){
            int index = quotas.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last quotas. The list is empty.");
            return setNewQuotaLike(index, buildQuota(index));
    }

    public MemquotaFluent.QuotasNested<A> editMatchingQuota(io.fabric8.kubernetes.api.builder.Predicate<QuotaBuilder> predicate){
            int index = -1;
            for (int i=0;i<quotas.size();i++) { 
            if (predicate.apply(quotas.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching quotas. No match found.");
            return setNewQuotaLike(index, buildQuota(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            MemquotaFluentImpl that = (MemquotaFluentImpl) o;
            if (minDeduplicationDuration != null ? !minDeduplicationDuration.equals(that.minDeduplicationDuration) :that.minDeduplicationDuration != null) return false;
            if (quotas != null ? !quotas.equals(that.quotas) :that.quotas != null) return false;
            return true;
    }


    public class QuotasNestedImpl<N> extends QuotaFluentImpl<MemquotaFluent.QuotasNested<N>> implements MemquotaFluent.QuotasNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final QuotaBuilder builder;
        private final int index;
    
            QuotasNestedImpl(int index,Quota item){
                    this.index = index;
                    this.builder = new QuotaBuilder(this, item);
            }
            QuotasNestedImpl(){
                    this.index = -1;
                    this.builder = new QuotaBuilder(this);
            }
    
    public N and(){
            return (N) MemquotaFluentImpl.this.setToQuotas(index,builder.build());
    }
    public N endQuota(){
            return and();
    }

}


}
