
package me.snowdrop.istio.mixer.adapter.memquota;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "dimensions",
    "maxAmount",
    "validDuration"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Override implements Serializable
{

    /**
     * 
     */
    @JsonProperty("dimensions")
    @JsonPropertyDescription("")
    private Map<String, String> dimensions;
    /**
     * 
     */
    @JsonProperty("maxAmount")
    @JsonPropertyDescription("")
    private Integer maxAmount;
    /**
     * 
     */
    @JsonProperty("validDuration")
    @JsonPropertyDescription("")
    private Integer validDuration;
    private final static long serialVersionUID = -7318312159559492664L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Override() {
    }

    /**
     * 
     * @param validDuration
     * @param maxAmount
     * @param dimensions
     */
    public Override(Map<String, String> dimensions, Integer maxAmount, Integer validDuration) {
        super();
        this.dimensions = dimensions;
        this.maxAmount = maxAmount;
        this.validDuration = validDuration;
    }

    /**
     * 
     */
    public Map<String, String> getDimensions() {
        return dimensions;
    }

    /**
     * 
     */
    public void setDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions;
    }

    /**
     * 
     */
    public Integer getMaxAmount() {
        return maxAmount;
    }

    /**
     * 
     */
    public void setMaxAmount(Integer maxAmount) {
        this.maxAmount = maxAmount;
    }

    /**
     * 
     */
    public Integer getValidDuration() {
        return validDuration;
    }

    /**
     * 
     */
    public void setValidDuration(Integer validDuration) {
        this.validDuration = validDuration;
    }

}
