package me.snowdrop.istio.mixer.adapter.memquota;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OverrideBuilder extends OverrideFluentImpl<OverrideBuilder> implements VisitableBuilder<me.snowdrop.istio.mixer.adapter.memquota.Override,OverrideBuilder>{

    OverrideFluent<?> fluent;
    Boolean validationEnabled;

    public OverrideBuilder(){
            this(true);
    }
    public OverrideBuilder(Boolean validationEnabled){
            this(new Override(), validationEnabled);
    }
    public OverrideBuilder(OverrideFluent<?> fluent){
            this(fluent, true);
    }
    public OverrideBuilder(OverrideFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Override(), validationEnabled);
    }
    public OverrideBuilder(OverrideFluent<?> fluent,me.snowdrop.istio.mixer.adapter.memquota.Override instance){
            this(fluent, instance, true);
    }
    public OverrideBuilder(OverrideFluent<?> fluent,me.snowdrop.istio.mixer.adapter.memquota.Override instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDimensions(instance.getDimensions()); 
            fluent.withMaxAmount(instance.getMaxAmount()); 
            fluent.withValidDuration(instance.getValidDuration()); 
            this.validationEnabled = validationEnabled; 
    }
    public OverrideBuilder(me.snowdrop.istio.mixer.adapter.memquota.Override instance){
            this(instance,true);
    }
    public OverrideBuilder(me.snowdrop.istio.mixer.adapter.memquota.Override instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDimensions(instance.getDimensions()); 
            this.withMaxAmount(instance.getMaxAmount()); 
            this.withValidDuration(instance.getValidDuration()); 
            this.validationEnabled = validationEnabled; 
    }

    public me.snowdrop.istio.mixer.adapter.memquota.Override build(){
            Override buildable = new Override(fluent.getDimensions(),fluent.getMaxAmount(),fluent.getValidDuration());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OverrideBuilder that = (OverrideBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
