package me.snowdrop.istio.mixer.adapter.memquota;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public interface OverrideFluent<A extends OverrideFluent<A>> extends Fluent<A>{


    public A addToDimensions(String key,String value);
    public A addToDimensions(Map<String,String> map);
    public A removeFromDimensions(String key);
    public A removeFromDimensions(Map<String,String> map);
    public Map<String,String> getDimensions();
    public A withDimensions(Map<String,String> dimensions);
    public Boolean hasDimensions();
    public Integer getMaxAmount();
    public A withMaxAmount(Integer maxAmount);
    public Boolean hasMaxAmount();
    public Integer getValidDuration();
    public A withValidDuration(Integer validDuration);
    public Boolean hasValidDuration();



}
