
package me.snowdrop.istio.mixer.adapter.memquota;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "maxAmount",
    "name",
    "overrides",
    "validDuration"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Quota implements Serializable
{

    /**
     * 
     */
    @JsonProperty("maxAmount")
    @JsonPropertyDescription("")
    private Integer maxAmount;
    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     */
    @JsonProperty("overrides")
    @JsonPropertyDescription("")
    private List<Override> overrides = new ArrayList<Override>();
    /**
     * 
     */
    @JsonProperty("validDuration")
    @JsonPropertyDescription("")
    private Integer validDuration;
    private final static long serialVersionUID = -9087988441793206143L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Quota() {
    }

    /**
     * 
     * @param name
     * @param validDuration
     * @param overrides
     * @param maxAmount
     */
    public Quota(Integer maxAmount, String name, List<Override> overrides, Integer validDuration) {
        super();
        this.maxAmount = maxAmount;
        this.name = name;
        this.overrides = overrides;
        this.validDuration = validDuration;
    }

    /**
     * 
     */
    public Integer getMaxAmount() {
        return maxAmount;
    }

    /**
     * 
     */
    public void setMaxAmount(Integer maxAmount) {
        this.maxAmount = maxAmount;
    }

    /**
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     */
    public List<Override> getOverrides() {
        return overrides;
    }

    /**
     * 
     */
    public void setOverrides(List<Override> overrides) {
        this.overrides = overrides;
    }

    /**
     * 
     */
    public Integer getValidDuration() {
        return validDuration;
    }

    /**
     * 
     */
    public void setValidDuration(Integer validDuration) {
        this.validDuration = validDuration;
    }

}
